/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.async;

import com.alibaba.ttl.TtlCallable;
import com.alibaba.ttl.TtlRunnable;
import com.alibaba.ttl.threadpool.TtlExecutors;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.concurrent.ListenableFuture;

public class TtlThreadPoolTaskScheduler
extends ThreadPoolTaskScheduler {
    protected final boolean releaseTtlValueReferenceAfterRun;
    protected final boolean idempotent;

    public TtlThreadPoolTaskScheduler() {
        this(false, true);
    }

    public TtlThreadPoolTaskScheduler(boolean releaseTtlValueReferenceAfterRun, boolean idempotent) {
        this.idempotent = idempotent;
        this.releaseTtlValueReferenceAfterRun = releaseTtlValueReferenceAfterRun;
    }

    @NotNull
    protected ExecutorService initializeExecutor(@NotNull ThreadFactory threadFactory, @NotNull RejectedExecutionHandler rejectedExecutionHandler) {
        ExecutorService es = super.initializeExecutor(threadFactory, rejectedExecutionHandler);
        return TtlExecutors.getTtlExecutorService((ExecutorService)es);
    }

    public void execute(@NotNull Runnable task) {
        super.execute((Runnable)TtlRunnable.get((Runnable)task, (boolean)this.releaseTtlValueReferenceAfterRun, (boolean)this.idempotent));
    }

    @NotNull
    public Future<?> submit(@NotNull Runnable task) {
        return super.submit((Runnable)TtlRunnable.get((Runnable)task, (boolean)this.releaseTtlValueReferenceAfterRun, (boolean)this.idempotent));
    }

    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        return super.submit((Callable)TtlCallable.get(task, (boolean)this.releaseTtlValueReferenceAfterRun, (boolean)this.idempotent));
    }

    @Deprecated
    @NotNull
    public ListenableFuture<?> submitListenable(@NotNull Runnable task) {
        return super.submitListenable((Runnable)TtlRunnable.get((Runnable)task, (boolean)this.releaseTtlValueReferenceAfterRun, (boolean)this.idempotent));
    }

    @Deprecated
    @NotNull
    public <T> ListenableFuture<T> submitListenable(@NotNull Callable<T> task) {
        return super.submitListenable((Callable)TtlCallable.get(task, (boolean)this.releaseTtlValueReferenceAfterRun, (boolean)this.idempotent));
    }

    public ScheduledFuture<?> schedule(@NotNull Runnable task, @NotNull Trigger trigger) {
        return super.schedule((Runnable)TtlRunnable.get((Runnable)task, (boolean)this.releaseTtlValueReferenceAfterRun, (boolean)this.idempotent), trigger);
    }

    @Deprecated
    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable task, @NotNull Date startTime) {
        return this.schedule(task, startTime.toInstant());
    }

    @Deprecated
    @NotNull
    public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable task, @NotNull Date startTime, long period) {
        return this.scheduleAtFixedRate(task, startTime.toInstant(), Duration.ofMillis(period));
    }

    @Deprecated
    @NotNull
    public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable task, long period) {
        return this.scheduleAtFixedRate(task, Duration.ofMillis(period));
    }

    @Deprecated
    @NotNull
    public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable task, @NotNull Date startTime, long delay) {
        return this.scheduleWithFixedDelay(task, startTime.toInstant(), Duration.ofMillis(delay));
    }

    @Deprecated
    @NotNull
    public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable task, long delay) {
        return this.scheduleWithFixedDelay(task, Duration.ofMillis(delay));
    }

    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable task, @NotNull Instant startTime) {
        return super.schedule((Runnable)TtlRunnable.get((Runnable)task, (boolean)this.releaseTtlValueReferenceAfterRun, (boolean)this.idempotent), startTime);
    }

    @NotNull
    public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable task, @NotNull Instant startTime, @NotNull Duration period) {
        return super.scheduleAtFixedRate((Runnable)TtlRunnable.get((Runnable)task, (boolean)this.releaseTtlValueReferenceAfterRun, (boolean)this.idempotent), startTime, period);
    }

    @NotNull
    public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable task, @NotNull Duration period) {
        return super.scheduleAtFixedRate((Runnable)TtlRunnable.get((Runnable)task, (boolean)this.releaseTtlValueReferenceAfterRun, (boolean)this.idempotent), period);
    }

    @NotNull
    public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable task, @NotNull Instant startTime, @NotNull Duration delay) {
        return super.scheduleWithFixedDelay((Runnable)TtlRunnable.get((Runnable)task, (boolean)this.releaseTtlValueReferenceAfterRun, (boolean)this.idempotent), startTime, delay);
    }

    @NotNull
    public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable task, @NotNull Duration delay) {
        return super.scheduleWithFixedDelay((Runnable)TtlRunnable.get((Runnable)task, (boolean)this.releaseTtlValueReferenceAfterRun, (boolean)this.idempotent), delay);
    }

    @NotNull
    public Thread newThread(@NotNull Runnable task) {
        return super.newThread((Runnable)TtlRunnable.get((Runnable)task, (boolean)this.releaseTtlValueReferenceAfterRun, (boolean)this.idempotent));
    }

    @NotNull
    public Thread createThread(@NotNull Runnable task) {
        return super.createThread((Runnable)TtlRunnable.get((Runnable)task, (boolean)this.releaseTtlValueReferenceAfterRun, (boolean)this.idempotent));
    }
}

