/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.autozone.json;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import pro.fessional.mirana.time.DateParser;

public class JacksonLocalTimeDeserializer
extends LocalTimeDeserializer {
    private final List<DateTimeFormatter> formats;

    public JacksonLocalTimeDeserializer(DateTimeFormatter formatter, List<DateTimeFormatter> formats) {
        super(formatter);
        this.formats = formats;
    }

    protected JacksonLocalTimeDeserializer(LocalTimeDeserializer base, Boolean leniency, List<DateTimeFormatter> formats) {
        super(base, leniency);
        this.formats = formats;
    }

    protected LocalTimeDeserializer withDateFormat(DateTimeFormatter dtf) {
        if (dtf == this._formatter) {
            return this;
        }
        ArrayList<DateTimeFormatter> fts = new ArrayList<DateTimeFormatter>(this.formats.size());
        fts.add(dtf);
        fts.addAll(this.formats);
        return new JacksonLocalTimeDeserializer(dtf, fts);
    }

    protected LocalTimeDeserializer withLeniency(Boolean leniency) {
        return new JacksonLocalTimeDeserializer(this, leniency, this.formats);
    }

    protected LocalTimeDeserializer withShape(JsonFormat.Shape shape) {
        return this;
    }

    public LocalTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        TemporalAccessor tma = DateParser.parseTemporal((CharSequence)parser.getText(), this.formats, (boolean)true);
        if (tma == null) {
            return super.deserialize(parser, context);
        }
        LocalTime ldt = (LocalTime)tma.query(DateParser.QueryTime);
        return ldt != null ? ldt : super.deserialize(parser, context);
    }
}

