/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.cache;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.CacheOperation;
import pro.fessional.mirana.best.AssertState;

public class WingsCacheHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WingsCacheHelper.class);
    private static final Map<String, CacheManager> managers = new ConcurrentHashMap<String, CacheManager>();
    private static final Map<CacheManager, Set<String>> namings = new ConcurrentHashMap<CacheManager, Set<String>>();
    private static CacheManager memory;
    private static CacheManager server;
    private static final Map<Class<?>, Map<String, Meta>> classes;

    @Nullable
    public static CacheManager getCacheManager(String name) {
        if ("MemoryCacheManager".equalsIgnoreCase(name)) {
            return memory;
        }
        if ("ServerCacheManager".equalsIgnoreCase(name)) {
            return server;
        }
        return managers.get(name);
    }

    public static Set<String> getManagerNames(CacheManager manage) {
        if (manage == null) {
            return Collections.emptySet();
        }
        return namings.getOrDefault(manage, Collections.emptySet());
    }

    @Nullable
    public static Cache getCache(String manager, String cache) {
        CacheManager cm = WingsCacheHelper.getCacheManager(manager);
        return cm == null ? null : cm.getCache(cache);
    }

    @NotNull
    public static Cache getMemoryCache(String name) {
        Cache cache = memory.getCache(name);
        AssertState.notNull((Object)cache, (String)"memory cache is null, name={}", (Object[])new Object[]{name});
        return cache;
    }

    @NotNull
    public static Cache getServerCache(String name) {
        Cache cache = server.getCache(name);
        AssertState.notNull((Object)cache, (String)"server cache is null, name={}", (Object[])new Object[]{name});
        return cache;
    }

    public static void putManagers(Map<String, CacheManager> mngs) {
        managers.putAll(mngs);
        memory = managers.get("MemoryCacheManager");
        server = managers.get("ServerCacheManager");
        namings.clear();
        for (Map.Entry<String, CacheManager> en : managers.entrySet()) {
            namings.computeIfAbsent(en.getValue(), k -> new HashSet()).add(en.getKey());
        }
    }

    @NotNull
    public static CacheManager getMemory() {
        AssertState.notNull((Object)memory, (String)"Memory CacheManager is null");
        return memory;
    }

    @NotNull
    public static CacheManager getServer() {
        AssertState.notNull((Object)server, (String)"Server CacheManager is null");
        return server;
    }

    @NotNull
    public static Map<String, Set<String>> getCacheMeta(Class<?> clz) {
        return WingsCacheHelper.getCacheMeta(clz, "");
    }

    @NotNull
    public static Map<String, Set<String>> getCacheMeta(Class<?> claz, String method) {
        Meta mt;
        Map<String, Meta> map = classes.get(claz);
        if (map == null) {
            return Collections.emptyMap();
        }
        if (method == null) {
            method = "";
        }
        return (mt = map.get(method)) == null ? Collections.emptyMap() : mt.metaMap;
    }

    @NotNull
    public static Map<CacheManager, Set<String>> getManager(Class<?> clz) {
        return WingsCacheHelper.getManager(clz, "");
    }

    @NotNull
    public static Map<CacheManager, Set<String>> getManager(Class<?> claz, String method) {
        Meta mt;
        Map<String, Meta> map = classes.get(claz);
        if (map == null) {
            return Collections.emptyMap();
        }
        if (method == null) {
            method = "";
        }
        return (mt = map.get(method)) == null ? Collections.emptyMap() : mt.getManagers();
    }

    @NotNull
    public static Map<String, Set<Cache>> getCaches(Class<?> clz) {
        return WingsCacheHelper.getCaches(clz, "");
    }

    @NotNull
    public static Map<String, Set<Cache>> getCaches(Class<?> claz, String method) {
        Meta mt;
        Map<String, Meta> map = classes.get(claz);
        if (map == null) {
            return Collections.emptyMap();
        }
        if (method == null) {
            method = "";
        }
        return (mt = map.get(method)) == null ? Collections.emptyMap() : mt.getCaches();
    }

    public static void setOperation(Method method, Collection<CacheOperation> opr) {
        if (opr == null || opr.isEmpty()) {
            return;
        }
        Map entry = classes.computeIfAbsent(method.getDeclaringClass(), k -> new ConcurrentHashMap());
        Meta top = entry.computeIfAbsent("", k -> new Meta());
        Meta mod = entry.computeIfAbsent(method.getName(), k -> new Meta());
        for (CacheOperation op : opr) {
            String cr = op.getCacheResolver();
            String cm = op.getCacheManager();
            Set cs = op.getCacheNames();
            top.initOperation(cr, cm, cs);
            mod.initOperation(cr, cm, cs);
        }
    }

    static {
        classes = new ConcurrentHashMap();
    }

    public static class Meta {
        private final Map<String, Set<String>> metaMap = new HashMap<String, Set<String>>();
        private final Map<CacheManager, Set<String>> objManager = new HashMap<CacheManager, Set<String>>();
        private final Map<String, Set<Cache>> objCache = new HashMap<String, Set<Cache>>();

        public void initOperation(String cr, String cm, Set<String> cs) {
            if (!cr.isEmpty()) {
                this.metaMap.computeIfAbsent(cr, k -> new HashSet()).addAll(cs);
            }
            if (!cm.isEmpty()) {
                this.metaMap.computeIfAbsent(cm, k -> new HashSet()).addAll(cs);
            }
        }

        public Map<CacheManager, Set<String>> getManagers() {
            if (this.metaMap.isEmpty()) {
                return this.objManager;
            }
            if (this.objManager.isEmpty()) {
                for (String nm : this.metaMap.keySet()) {
                    CacheManager m = WingsCacheHelper.getCacheManager(nm);
                    AssertState.notNull((Object)m, (String)"no CacheManager for {}", (Object[])new Object[]{nm});
                    this.objManager.put(m, WingsCacheHelper.getManagerNames(m));
                }
            }
            return this.objManager;
        }

        public Map<String, Set<Cache>> getCaches() {
            if (this.metaMap.isEmpty()) {
                return this.objCache;
            }
            if (this.objCache.isEmpty()) {
                for (Map.Entry<String, Set<String>> en : this.metaMap.entrySet()) {
                    String k = en.getKey();
                    CacheManager m = WingsCacheHelper.getCacheManager(k);
                    AssertState.notNull((Object)m, (String)"no CacheManager for {}", (Object[])new Object[]{k});
                    HashSet<Cache> st = new HashSet<Cache>();
                    for (String c : en.getValue()) {
                        st.add(m.getCache(c));
                    }
                    this.objCache.put(k, st);
                }
            }
            return this.objCache;
        }
    }
}

