/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.cache.cache2k;

import java.time.Duration;
import org.cache2k.Cache2kBuilder;
import org.cache2k.config.ToggleFeature;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pro.fessional.wings.slardar.cache.WingsCache;

public class WingsCache2k {
    public static Class<? extends ToggleFeature> FeatureJmx = WingsCache2k.initFeatureJmx();

    private static Class<? extends ToggleFeature> initFeatureJmx() {
        try {
            return Class.forName("org.cache2k.extra.jmx.JmxSupport");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @NotNull
    public static Cache2kBuilder<Object, Object> builder(Class<?> owner, String use, int max, int ttl, int tti) {
        return WingsCache2k.builder(Cache2kBuilder.forUnknownTypes().name(WingsCache.Naming.use(owner, use)), max, ttl, tti, true);
    }

    @NotNull
    public static <K, V> Cache2kBuilder<K, V> builder(Class<?> owner, String use, int max, int ttl, int tti, Class<K> k, Class<V> v) {
        return WingsCache2k.builder(Cache2kBuilder.of(k, v).name(WingsCache.Naming.use(owner, use)), max, ttl, tti, true);
    }

    @NotNull
    public static Cache2kBuilder<Object, Object> builder(Class<?> owner, String use, int max, Duration ttl, Duration tti) {
        return WingsCache2k.builder(Cache2kBuilder.forUnknownTypes().name(WingsCache.Naming.use(owner, use)), max, ttl, tti, true);
    }

    @NotNull
    public static <K, V> Cache2kBuilder<K, V> builder(Class<?> owner, String use, int max, Duration ttl, Duration tti, Class<K> k, Class<V> v) {
        return WingsCache2k.builder(Cache2kBuilder.of(k, v).name(WingsCache.Naming.use(owner, use)), max, ttl, tti, true);
    }

    @Contract(value="_,_,_,_,_->param1")
    public static <K, V> Cache2kBuilder<K, V> builder(Cache2kBuilder<K, V> bld, int max, int ttl, int tti, boolean feature) {
        return WingsCache2k.builder(bld, max, ttl > 0 ? Duration.ofSeconds(ttl) : null, tti > 0 ? Duration.ofSeconds(tti) : null, feature);
    }

    @Contract(value="_,_,_,_,_->param1")
    public static <K, V> Cache2kBuilder<K, V> builder(Cache2kBuilder<K, V> bld, int max, Duration ttl, Duration tti, boolean feature) {
        if (feature && FeatureJmx != null) {
            bld.enable(FeatureJmx);
        }
        if (max > 0) {
            bld.entryCapacity((long)max);
        }
        if (ttl != null && ttl.toSeconds() > 0L) {
            bld.expireAfterWrite(ttl);
        }
        if (tti != null && tti.toSeconds() > 0L) {
            bld.idleScanTime(tti);
        }
        return bld;
    }
}

