/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.event;

import java.util.concurrent.Executor;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class EventPublishHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventPublishHelper.class);
    public static final ApplicationEventPublisher SyncSpring = new SyncPub();
    public static final ApplicationEventPublisher AsyncSpring = new AsyncPub();
    public static final ApplicationEventPublisher AsyncGlobal = new GlobalPub(true);
    public static final ApplicationEventPublisher AsyncWidely = new GlobalPub(false);
    private static Executor executor;
    private static ApplicationEventPublisher springPublisher;
    private static ApplicationEventPublisher globalPublisher;

    public static void setGlobalPublisher(ApplicationEventPublisher globalPublisher) {
        EventPublishHelper.globalPublisher = globalPublisher;
    }

    public static void setExecutor(Executor executor) {
        EventPublishHelper.executor = executor;
    }

    public static void setSpringPublisher(ApplicationEventPublisher springPublisher) {
        EventPublishHelper.springPublisher = springPublisher;
    }

    public static boolean hasAsyncGlobal() {
        return globalPublisher != null;
    }

    private static class SyncPub
    implements ApplicationEventPublisher {
        private SyncPub() {
        }

        public void publishEvent(@NotNull Object event) {
            springPublisher.publishEvent(event);
        }
    }

    private static class AsyncPub
    implements ApplicationEventPublisher {
        private AsyncPub() {
        }

        public void publishEvent(@NotNull Object event) {
            executor.execute(() -> springPublisher.publishEvent(event));
        }
    }

    private static class GlobalPub
    implements ApplicationEventPublisher {
        private final boolean strict;

        public void publishEvent(@NotNull Object event) {
            if (globalPublisher != null) {
                executor.execute(() -> globalPublisher.publishEvent(event));
            } else {
                if (this.strict) {
                    throw new IllegalStateException("no globalPublisher, use #hasAsyncGlobal to test");
                }
                log.warn("no globalPublisher, publish by spring async in no strict");
                executor.execute(() -> springPublisher.publishEvent(event));
            }
        }

        @Generated
        public GlobalPub(boolean strict) {
            this.strict = strict;
        }
    }
}

