/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.event.tweak;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.logging.LogLevel;
import org.springframework.context.event.EventListener;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.silencer.tweak.TweakClock;
import pro.fessional.wings.silencer.tweak.TweakLogger;
import pro.fessional.wings.silencer.tweak.TweakStack;
import pro.fessional.wings.slardar.context.TerminalContext;
import pro.fessional.wings.slardar.event.tweak.TweakClockEvent;
import pro.fessional.wings.slardar.event.tweak.TweakLoggerEvent;
import pro.fessional.wings.slardar.event.tweak.TweakStackEvent;

public class TweakEventListener
implements TerminalContext.Listener {
    public static final long FixDate = Duration.ofDays(3650L).toMillis();
    public static final long GlobalUid = Long.MAX_VALUE;
    private final ConcurrentHashMap<Long, Conf> debugs = new ConcurrentHashMap();
    private final Conf global = new Conf();
    private static final Conf Null = new Conf();

    @EventListener
    public void tweakLogger(TweakLoggerEvent event) {
        long uid = event.getUserId();
        Conf conf = uid == Long.MAX_VALUE ? this.global : this.debugs.computeIfAbsent(uid, k -> new Conf());
        LogLevel lvl = event.getLevel();
        if (lvl == LogLevel.OFF) {
            TweakLogger.resetThread();
            conf.logger = null;
        } else {
            conf.logger = lvl;
        }
    }

    @EventListener
    public void tweakStack(TweakStackEvent event) {
        long uid = event.getUserId();
        Conf conf = uid == Long.MAX_VALUE ? this.global : this.debugs.computeIfAbsent(uid, k -> new Conf());
        Boolean stack = event.getStack();
        if (stack == null) {
            TweakStack.resetThread();
        }
        conf.stack = stack;
    }

    @EventListener
    public void tweakClock(TweakClockEvent event) {
        long uid = event.getUserId();
        Conf conf = uid == Long.MAX_VALUE ? this.global : this.debugs.computeIfAbsent(uid, k -> new Conf());
        long offset = event.getMills();
        if (offset == 0L) {
            TweakClock.resetThread();
            conf.clock = null;
        } else {
            conf.clock = offset < FixDate ? Clock.offset((Clock)ThreadNow.TweakClock.defaultValue(true), Duration.ofMillis(offset)) : Clock.fixed(Instant.ofEpochMilli(offset), ThreadNow.sysZoneId());
        }
    }

    @Override
    public void onChange(boolean del, @NotNull TerminalContext.Context ctx) {
        Conf cur = this.debugs.getOrDefault(ctx.getUserId(), Null);
        Clock cc = cur.clock;
        LogLevel cl = cur.logger;
        Boolean cs = cur.stack;
        if (del) {
            if (cc != null || this.global.clock != null) {
                TweakClock.resetThread();
            }
            if (cl != null || this.global.logger != null) {
                TweakLogger.resetThread();
            }
            if (cs != null || this.global.stack != null) {
                TweakStack.resetThread();
            }
            if (cur != Null && cc == null && cl == null && cs == null) {
                this.debugs.remove(ctx.getUserId());
            }
        } else {
            Boolean ds;
            LogLevel dl;
            Clock dc;
            Clock clock = dc = cc != null ? cc : this.global.clock;
            if (dc != null) {
                TweakClock.tweakThread((Clock)dc);
            }
            LogLevel logLevel = dl = cl != null ? cl : this.global.logger;
            if (dl != null) {
                TweakLogger.tweakThread((LogLevel)dl);
            }
            Boolean bl = ds = cs != null ? cs : this.global.stack;
            if (ds != null) {
                TweakStack.tweakThread((boolean)ds);
            }
        }
    }

    private static class Conf {
        private transient Clock clock;
        private transient LogLevel logger;
        private transient Boolean stack;

        private Conf() {
        }
    }
}

