/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.httprest.okhttp;

import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import pro.fessional.wings.slardar.httprest.okhttp.OkHttpBuildableClient;

public class OkHttpTokenClient
implements Call.Factory,
OkHttpBuildableClient {
    private final Tokenize tokenize;
    private final Call.Factory tkClient;

    public OkHttpTokenClient(@NotNull OkHttpClient client, @NotNull Tokenize tokenize) {
        this.tokenize = tokenize;
        this.tkClient = client.newBuilder().authenticator((ignored, response) -> {
            Request.Builder bd;
            if (OkHttpTokenClient.syncInitToken(tokenize, (Call.Factory)client) && tokenize.fillToken(bd = response.request().newBuilder())) {
                return bd.build();
            }
            return null;
        }).build();
    }

    @NotNull
    public Call newCall(@NotNull Request request) {
        if (this.tokenize != null && this.tokenize.needToken(request)) {
            return this.newCall(request.newBuilder());
        }
        return this.tkClient.newCall(request);
    }

    @Override
    @NotNull
    public Call newCall(@NotNull Request.Builder builder) {
        if (!this.tokenize.fillToken(builder)) {
            if (OkHttpTokenClient.syncInitToken(this.tokenize, this.tkClient)) {
                if (!this.tokenize.fillToken(builder)) {
                    throw new IllegalStateException("failed to fill token");
                }
            } else {
                throw new IllegalStateException("failed to init token");
            }
        }
        return this.tkClient.newCall(builder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean syncInitToken(@NotNull Tokenize tokenize, @NotNull Call.Factory callFactory) {
        Request.Builder builder = new Request.Builder();
        Tokenize tokenize2 = tokenize;
        synchronized (tokenize2) {
            if (tokenize.fillToken(builder)) {
                return true;
            }
            return tokenize.initToken(callFactory);
        }
    }

    public static interface Tokenize {
        public boolean needToken(@NotNull Request var1);

        public boolean fillToken(Request.Builder var1);

        public boolean initToken(@NotNull Call.Factory var1);
    }
}

