/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.httprest.okhttp;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.Generated;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.mirana.code.RandCode;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.slardar.context.Now;
import pro.fessional.wings.slardar.httprest.okhttp.OkHttpClientHelper;
import pro.fessional.wings.slardar.httprest.okhttp.OkHttpTokenClient;
import pro.fessional.wings.slardar.jackson.JacksonHelper;

public class OkHttpTokenizeOauth
implements OkHttpTokenClient.Tokenize {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OkHttpTokenizeOauth.class);
    public static final String AuthHeader = "Authorization";
    public static final String BearerPrefix = "Bearer ";
    public static final String AuthorizationCode = "authorization_code";
    public static final String ClientCredentials = "client_credentials";
    public static final String RefreshToken = "refresh_token";
    private String clientId;
    private String clientSecret;
    private String redirectUri;
    private String scopes;
    private String authorizeUrl;
    private String accessTokenUrl;
    private String headerAccept = "application/json";
    private String headerUserAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36";
    private String keyGrantType = "grant_type";
    private String valRefreshToken = "refresh_token";
    private String valAccessToken = "client_credentials";
    private String keyRefreshToken = "refresh_token";
    private String keyClientId = "client_id";
    private String keyRedirectUri = "redirect_uri";
    private String keyResponseType = "response_type";
    private String valResponseTypeCode = "code";
    private String keyScope = "scope";
    private String keyState = "state";
    private String keyAuthorizationCode = "authorization_code";
    private String keyCode = "code";
    private String keyClientSecret = "client_secret";
    private String keyAccessToken = "access_token";
    private String keyExpiresIn = "expires_in";
    private int expireBuff = 30000;
    private transient Token token;

    @Override
    public boolean needToken(@NotNull Request request) {
        String ah = request.header(AuthHeader);
        return ah == null || !ah.startsWith(BearerPrefix);
    }

    @Override
    public boolean fillToken(Request.Builder builder) {
        Token tkn = this.token;
        if (tkn == null) {
            return false;
        }
        long now = ThreadNow.millis();
        if (now > tkn.expired) {
            return false;
        }
        builder.header(AuthHeader, tkn.access);
        return true;
    }

    @Override
    public boolean initToken(@NotNull Call.Factory callFactory) {
        Token tkn = this.token;
        Token newTkn = null;
        if (tkn != null && tkn.refresh != null) {
            newTkn = this.fetchByRefresh(callFactory, tkn.refresh);
        }
        if (newTkn == null) {
            newTkn = this.fetchByGrantType(callFactory);
        }
        this.token = newTkn;
        return newTkn != null;
    }

    protected Token fetchByRefresh(@NotNull Call.Factory callFactory, @NotNull String refresh) {
        FormBody.Builder builder = this.buildRefresh(new FormBody.Builder()).add(this.keyGrantType, this.valRefreshToken).add(this.keyRefreshToken, refresh);
        if (this.redirectUri != null) {
            builder.add(this.keyRedirectUri, this.redirectUri);
        }
        Request request = this.buildCommonRequest(new Request.Builder()).url(this.accessTokenUrl).post((RequestBody)builder.build()).build();
        String body = OkHttpClientHelper.executeString(callFactory, request, false);
        return this.parseToken(body);
    }

    @Contract(value="_->param1")
    protected FormBody.Builder buildRefresh(@NotNull FormBody.Builder builder) {
        return builder;
    }

    protected Token fetchByGrantType(@NotNull Call.Factory callFactory) {
        boolean notnull;
        String code;
        if (ClientCredentials.equals(this.valAccessToken)) {
            code = null;
            notnull = false;
        } else if (AuthorizationCode.equals(this.valAccessToken)) {
            code = this.fetchAuthorizationCode(callFactory);
            notnull = true;
        } else {
            log.warn("AccessToken must is {} or {}", (Object)ClientCredentials, (Object)AuthorizationCode);
            return null;
        }
        if (notnull && code == null) {
            return null;
        }
        return this.fetchAccessToken(callFactory, code);
    }

    @Nullable
    protected Token fetchAccessToken(@NotNull Call.Factory callFactory, String code) {
        FormBody.Builder builder = this.buildAccessToken(new FormBody.Builder()).add(this.keyGrantType, this.valAccessToken).add(this.keyClientId, this.clientId).add(this.keyClientSecret, this.clientSecret);
        if (this.redirectUri != null) {
            builder.add(this.keyRedirectUri, this.redirectUri);
        }
        if (code != null) {
            builder.add(this.keyCode, code);
        }
        Request request = this.buildCommonRequest(new Request.Builder()).url(this.accessTokenUrl).post((RequestBody)builder.build()).build();
        String body = OkHttpClientHelper.executeString(callFactory, request, false);
        return this.parseToken(body);
    }

    @Contract(value="_->param1")
    protected FormBody.Builder buildAccessToken(@NotNull FormBody.Builder builder) {
        return builder;
    }

    @Nullable
    protected String fetchAuthorizationCode(@NotNull Call.Factory callFactory) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.authorizeUrl);
        if (httpUrl == null) {
            return null;
        }
        String state = RandCode.numlet((int)16);
        HttpUrl.Builder builder = this.buildAuthorizationCode(httpUrl.newBuilder()).addQueryParameter(this.keyClientId, this.clientId).addQueryParameter(this.keyResponseType, this.valResponseTypeCode).addQueryParameter(this.keyState, state);
        if (this.redirectUri != null) {
            builder.addQueryParameter(this.keyRedirectUri, this.redirectUri);
        }
        if (this.scopes != null) {
            builder.addQueryParameter(this.keyScope, this.scopes);
        }
        Request request = this.buildCommonRequest(new Request.Builder()).url(builder.build()).get().build();
        Response response = OkHttpClientHelper.execute(callFactory, request, false);
        return this.parseAuthorizationCode(response, state);
    }

    @Contract(value="_->param1")
    protected HttpUrl.Builder buildAuthorizationCode(@NotNull HttpUrl.Builder builder) {
        return builder;
    }

    protected String parseAuthorizationCode(@NotNull Response response, @NotNull String state) {
        String cd;
        String loc = response.header("Location");
        HttpUrl acUrl = loc != null ? HttpUrl.parse((String)loc) : response.request().url();
        if (acUrl != null && state.equals(acUrl.queryParameter(this.keyState)) && (cd = acUrl.queryParameter(this.keyCode)) != null) {
            return cd;
        }
        ResponseBody body = response.body();
        if (body != null && (this.headerAccept.contains("json") || this.headerAccept.contains("xml"))) {
            JsonNode node = JacksonHelper.object(body.string());
            return JacksonHelper.getString(node, this.keyCode, null);
        }
        return null;
    }

    @Contract(value="_->param1")
    protected Request.Builder buildCommonRequest(@NotNull Request.Builder builder) {
        return builder.header("Accept", this.headerAccept).header("User-Agent", this.headerUserAgent);
    }

    protected Token parseToken(String str) {
        if (str == null) {
            return null;
        }
        if (!this.headerAccept.contains("json") && !this.headerAccept.contains("xml")) {
            return null;
        }
        JsonNode node = JacksonHelper.object(str);
        String act = JacksonHelper.getString(node, this.keyAccessToken, null);
        int exp = JacksonHelper.getInt(node, this.keyExpiresIn, 0) * 1000;
        if (act == null || exp < this.expireBuff) {
            return null;
        }
        long ms = Now.millis() + (long)exp - (long)this.expireBuff;
        String rft = JacksonHelper.getString(node, this.keyRefreshToken, null);
        return new Token(ms, BearerPrefix + act, rft);
    }

    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    @Generated
    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    @Generated
    public void setAuthorizeUrl(String authorizeUrl) {
        this.authorizeUrl = authorizeUrl;
    }

    @Generated
    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    @Generated
    public void setHeaderAccept(String headerAccept) {
        this.headerAccept = headerAccept;
    }

    @Generated
    public void setHeaderUserAgent(String headerUserAgent) {
        this.headerUserAgent = headerUserAgent;
    }

    @Generated
    public void setKeyGrantType(String keyGrantType) {
        this.keyGrantType = keyGrantType;
    }

    @Generated
    public void setValRefreshToken(String valRefreshToken) {
        this.valRefreshToken = valRefreshToken;
    }

    @Generated
    public void setValAccessToken(String valAccessToken) {
        this.valAccessToken = valAccessToken;
    }

    @Generated
    public void setKeyRefreshToken(String keyRefreshToken) {
        this.keyRefreshToken = keyRefreshToken;
    }

    @Generated
    public void setKeyClientId(String keyClientId) {
        this.keyClientId = keyClientId;
    }

    @Generated
    public void setKeyRedirectUri(String keyRedirectUri) {
        this.keyRedirectUri = keyRedirectUri;
    }

    @Generated
    public void setKeyResponseType(String keyResponseType) {
        this.keyResponseType = keyResponseType;
    }

    @Generated
    public void setValResponseTypeCode(String valResponseTypeCode) {
        this.valResponseTypeCode = valResponseTypeCode;
    }

    @Generated
    public void setKeyScope(String keyScope) {
        this.keyScope = keyScope;
    }

    @Generated
    public void setKeyState(String keyState) {
        this.keyState = keyState;
    }

    @Generated
    public void setKeyAuthorizationCode(String keyAuthorizationCode) {
        this.keyAuthorizationCode = keyAuthorizationCode;
    }

    @Generated
    public void setKeyCode(String keyCode) {
        this.keyCode = keyCode;
    }

    @Generated
    public void setKeyClientSecret(String keyClientSecret) {
        this.keyClientSecret = keyClientSecret;
    }

    @Generated
    public void setKeyAccessToken(String keyAccessToken) {
        this.keyAccessToken = keyAccessToken;
    }

    @Generated
    public void setKeyExpiresIn(String keyExpiresIn) {
        this.keyExpiresIn = keyExpiresIn;
    }

    @Generated
    public void setExpireBuff(int expireBuff) {
        this.expireBuff = expireBuff;
    }

    @Generated
    public void setToken(Token token) {
        this.token = token;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public String getRedirectUri() {
        return this.redirectUri;
    }

    @Generated
    public String getScopes() {
        return this.scopes;
    }

    @Generated
    public String getAuthorizeUrl() {
        return this.authorizeUrl;
    }

    @Generated
    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    @Generated
    public String getHeaderAccept() {
        return this.headerAccept;
    }

    @Generated
    public String getHeaderUserAgent() {
        return this.headerUserAgent;
    }

    @Generated
    public String getKeyGrantType() {
        return this.keyGrantType;
    }

    @Generated
    public String getValRefreshToken() {
        return this.valRefreshToken;
    }

    @Generated
    public String getValAccessToken() {
        return this.valAccessToken;
    }

    @Generated
    public String getKeyRefreshToken() {
        return this.keyRefreshToken;
    }

    @Generated
    public String getKeyClientId() {
        return this.keyClientId;
    }

    @Generated
    public String getKeyRedirectUri() {
        return this.keyRedirectUri;
    }

    @Generated
    public String getKeyResponseType() {
        return this.keyResponseType;
    }

    @Generated
    public String getValResponseTypeCode() {
        return this.valResponseTypeCode;
    }

    @Generated
    public String getKeyScope() {
        return this.keyScope;
    }

    @Generated
    public String getKeyState() {
        return this.keyState;
    }

    @Generated
    public String getKeyAuthorizationCode() {
        return this.keyAuthorizationCode;
    }

    @Generated
    public String getKeyCode() {
        return this.keyCode;
    }

    @Generated
    public String getKeyClientSecret() {
        return this.keyClientSecret;
    }

    @Generated
    public String getKeyAccessToken() {
        return this.keyAccessToken;
    }

    @Generated
    public String getKeyExpiresIn() {
        return this.keyExpiresIn;
    }

    @Generated
    public int getExpireBuff() {
        return this.expireBuff;
    }

    @Generated
    public Token getToken() {
        return this.token;
    }

    public static class Token {
        private final long expired;
        private final String access;
        private final String refresh;

        @Generated
        public Token(long expired, String access, String refresh) {
            this.expired = expired;
            this.access = access;
            this.refresh = refresh;
        }

        @Generated
        public long getExpired() {
            return this.expired;
        }

        @Generated
        public String getAccess() {
            return this.access;
        }

        @Generated
        public String getRefresh() {
            return this.refresh;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Token)) {
                return false;
            }
            Token other = (Token)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpired() != other.getExpired()) {
                return false;
            }
            String this$access = this.getAccess();
            String other$access = other.getAccess();
            if (this$access == null ? other$access != null : !this$access.equals(other$access)) {
                return false;
            }
            String this$refresh = this.getRefresh();
            String other$refresh = other.getRefresh();
            return !(this$refresh == null ? other$refresh != null : !this$refresh.equals(other$refresh));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Token;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $expired = this.getExpired();
            result = result * 59 + (int)($expired >>> 32 ^ $expired);
            String $access = this.getAccess();
            result = result * 59 + ($access == null ? 43 : $access.hashCode());
            String $refresh = this.getRefresh();
            result = result * 59 + ($refresh == null ? 43 : $refresh.hashCode());
            return result;
        }

        @NotNull
        @Generated
        public String toString() {
            return "OkHttpTokenizeOauth.Token(expired=" + this.getExpired() + ", access=" + this.getAccess() + ", refresh=" + this.getRefresh() + ")";
        }
    }
}

