/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.jackson;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.NumberSerializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.StringUtils;

public class FormatNumberSerializer
extends NumberSerializer {
    private static final long MIN_SAFE_INTEGER = -9007199254740991L;
    private static final long MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFFL;
    private final DecimalFormat format;
    private final Digital digital;
    private final Map<String, DecimalFormat> poolsAuto = new ConcurrentHashMap<String, DecimalFormat>();
    private final Map<String, DecimalFormat> poolsNoop = new ConcurrentHashMap<String, DecimalFormat>();

    public FormatNumberSerializer(Class<? extends Number> rawType, DecimalFormat format, Digital digital) {
        super(rawType);
        this.format = format;
        this.digital = digital;
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        String ptn;
        if (this.format == null) {
            return super.createContextual(prov, property);
        }
        JsonFormat.Value jf = this.findFormatOverrides(prov, property, this.handledType());
        String string = ptn = jf == null ? null : jf.getPattern();
        if (StringUtils.hasLength((String)ptn)) {
            DecimalFormat df = jf.getShape() == JsonFormat.Shape.ANY ? this.poolsAuto.computeIfAbsent(ptn, k -> {
                DecimalFormat d = new DecimalFormat(ptn);
                d.setRoundingMode(this.format.getRoundingMode());
                d.setDecimalFormatSymbols(this.format.getDecimalFormatSymbols());
                return d;
            }) : this.poolsNoop.computeIfAbsent(ptn, k -> {
                DecimalFormat d = new DecimalFormat(ptn);
                d.setRoundingMode(this.format.getRoundingMode());
                return d;
            });
            return new FormatNumberSerializer(this._handledType, df, this.digital);
        }
        return this;
    }

    public void serialize(Number value, JsonGenerator g, SerializerProvider provider) throws IOException {
        if (this.format != null || this.digital != Digital.False || value instanceof Long || value instanceof Integer || value instanceof Float || value instanceof Double || value instanceof BigDecimal || value instanceof BigInteger) {
            String str;
            String string = str = this.format == null ? String.valueOf(value) : this.format.format(value);
            if (this.digital == Digital.True) {
                g.writeRawValue(str);
            } else if (this.digital == Digital.Auto) {
                long vl = value.longValue();
                if (vl <= -9007199254740991L || vl >= 0x1FFFFFFFFFFFFFL) {
                    g.writeNumber(str);
                } else {
                    g.writeRawValue(str);
                }
            } else {
                g.writeNumber(str);
            }
        } else {
            super.serialize(value, g, provider);
        }
    }

    public static enum Digital {
        Auto,
        True,
        False;

    }
}

