/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.text.WhiteUtil;

public class JacksonHelper {
    public static final ObjectMapper JsonPlain = new ObjectMapper();
    public static final XmlMapper XmlPlain = new XmlMapper();
    private static ObjectMapper JsonWings = JsonPlain;
    private static XmlMapper XmlWings = XmlPlain;

    public static void initGlobal(ObjectMapper jsonMapper, XmlMapper xmlMapper) {
        if (jsonMapper != null) {
            JsonWings = jsonMapper;
        }
        if (xmlMapper != null) {
            XmlWings = xmlMapper;
        }
    }

    @NotNull
    public static ObjectMapper JsonWings() {
        return JsonWings;
    }

    @NotNull
    public static XmlMapper XmlWings() {
        return XmlWings;
    }

    @NotNull
    public static ObjectMapper wings(boolean json) {
        return json ? JsonWings : XmlWings;
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(@Nullable String text, @NotNull Class<T> targetType) {
        if (JacksonHelper.asXml(text)) {
            return (T)XmlWings.readValue(text, targetType);
        }
        return (T)JsonWings.readValue(text, targetType);
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(@Nullable String text, @NotNull JavaType targetType) {
        if (JacksonHelper.asXml(text)) {
            return (T)XmlWings.readValue(text, targetType);
        }
        return (T)JsonWings.readValue(text, targetType);
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(@Nullable String text, @NotNull TypeReference<T> targetType) {
        if (JacksonHelper.asXml(text)) {
            return (T)XmlWings.readValue(text, targetType);
        }
        return (T)JsonWings.readValue(text, targetType);
    }

    @Contract(value="!null->!null")
    public static JsonNode object(@Nullable String text) {
        if (JacksonHelper.asXml(text)) {
            return XmlWings.readTree(text);
        }
        return JsonWings.readTree(text);
    }

    public static boolean asXml(@Nullable String str) {
        char c;
        int i;
        if (str == null) {
            return false;
        }
        int cnt = 0;
        int len = str.length();
        for (i = 0; i < len; ++i) {
            c = str.charAt(i);
            if (WhiteUtil.isWhiteSpace((char)c)) continue;
            if (c == '<') {
                ++cnt;
                break;
            }
            return false;
        }
        for (i = len - 1; i > 0; --i) {
            c = str.charAt(i);
            if (WhiteUtil.isWhiteSpace((char)c)) continue;
            if (c == '>') {
                ++cnt;
                break;
            }
            return false;
        }
        return cnt == 2;
    }

    @Contract(value="!null->!null")
    public static String string(@Nullable Object obj) {
        return JacksonHelper.string(obj, true);
    }

    @Contract(value="!null,_->!null")
    public static String string(@Nullable Object obj, boolean json) {
        if (obj == null) {
            return null;
        }
        if (json) {
            return JsonWings.writeValueAsString(obj);
        }
        return XmlWings.writeValueAsString(obj);
    }

    @Contract(value="_,_,!null->!null")
    public static String getString(JsonNode node, String field, String defaults) {
        if (node == null) {
            return defaults;
        }
        JsonNode jn = node.get(field);
        return jn != null ? jn.asText(defaults) : defaults;
    }

    public static boolean getBoolean(JsonNode node, String field, boolean defaults) {
        if (node == null) {
            return defaults;
        }
        JsonNode jn = node.get(field);
        return jn != null ? jn.asBoolean(defaults) : defaults;
    }

    public static int getInt(JsonNode node, String field, int defaults) {
        if (node == null) {
            return defaults;
        }
        JsonNode jn = node.get(field);
        return jn != null ? jn.asInt(defaults) : defaults;
    }

    public static long getLong(JsonNode node, String field, long defaults) {
        if (node == null) {
            return defaults;
        }
        JsonNode jn = node.get(field);
        return jn != null ? jn.asLong(defaults) : defaults;
    }

    public static double getDouble(JsonNode node, String field, double defaults) {
        if (node == null) {
            return defaults;
        }
        JsonNode jn = node.get(field);
        return jn != null ? jn.asDouble(defaults) : defaults;
    }
}

