/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.monitor.metric;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.mirana.stat.JvmStat;
import pro.fessional.wings.slardar.monitor.WarnMetric;

public class JvmMetric
implements WarnMetric {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JvmMetric.class);
    private final Rule rule;
    private final String keySystemCent;
    private final String keySystemLoad;
    private final String keyProcessCent;
    private final String keyProcessLoad;
    private final String keyMemoryLoad;
    private final String keyThreadCount;
    private final String keyThreadLoad;

    public JvmMetric(Rule rule) {
        this.rule = rule;
        this.keySystemCent = "wings.slardar.monitor.jvm.system-cent".substring("wings.slardar.monitor.jvm".length() + 1);
        this.keySystemLoad = "wings.slardar.monitor.jvm.system-load".substring("wings.slardar.monitor.jvm".length() + 1);
        this.keyProcessCent = "wings.slardar.monitor.jvm.process-cent".substring("wings.slardar.monitor.jvm".length() + 1);
        this.keyProcessLoad = "wings.slardar.monitor.jvm.process-load".substring("wings.slardar.monitor.jvm".length() + 1);
        this.keyMemoryLoad = "wings.slardar.monitor.jvm.memory-load".substring("wings.slardar.monitor.jvm".length() + 1);
        this.keyThreadCount = "wings.slardar.monitor.jvm.thread-count".substring("wings.slardar.monitor.jvm".length() + 1);
        this.keyThreadLoad = "wings.slardar.monitor.jvm.thread-load".substring("wings.slardar.monitor.jvm".length() + 1);
    }

    @Override
    @NotNull
    public String getKey() {
        return "wings.slardar.monitor.jvm";
    }

    public Rule getRule() {
        return this.rule;
    }

    @Override
    @NotNull
    public List<WarnMetric.Warn> check() {
        JvmStat.Stat stat = JvmStat.stat();
        log.info("JvmStat, stat={}", (Object)stat);
        ArrayList<WarnMetric.Warn> result = new ArrayList<WarnMetric.Warn>();
        this.check(result, this.keySystemCent, this.rule.systemCent, stat.getSystemCent());
        this.check(result, this.keySystemLoad, this.rule.systemLoad, stat.getSystemLoad());
        this.check(result, this.keyProcessCent, this.rule.processCent, stat.getProcessCent());
        this.check(result, this.keyProcessLoad, this.rule.processLoad, stat.getProcessLoad());
        this.check(result, this.keyMemoryLoad, this.rule.memoryLoad, stat.getMemoryLoad());
        this.check(result, this.keyThreadCount, this.rule.threadCount, stat.getThreadCount());
        this.check(result, this.keyThreadLoad, this.rule.threadCount, stat.getThreadLoad());
        return result;
    }

    private void check(List<WarnMetric.Warn> result, String key, int ruleValue, int warnValue) {
        if (ruleValue < 0 || warnValue < ruleValue) {
            return;
        }
        WarnMetric.Warn warn = new WarnMetric.Warn();
        warn.setKey(key);
        warn.setType(WarnMetric.Type.Text);
        warn.setRule(String.valueOf(ruleValue));
        warn.setWarn(String.valueOf(warnValue));
        result.add(warn);
    }

    public static class Rule {
        public static final String Key = "wings.slardar.monitor.jvm";
        private int systemCent = 90;
        public static final String Key$systemCent = "wings.slardar.monitor.jvm.system-cent";
        private int systemLoad = -1;
        public static final String Key$systemLoad = "wings.slardar.monitor.jvm.system-load";
        private int processCent = -1;
        public static final String Key$processCent = "wings.slardar.monitor.jvm.process-cent";
        private int processLoad = 150;
        public static final String Key$processLoad = "wings.slardar.monitor.jvm.process-load";
        private int memoryLoad = 90;
        public static final String Key$memoryLoad = "wings.slardar.monitor.jvm.memory-load";
        private int threadCount = -1;
        public static final String Key$threadCount = "wings.slardar.monitor.jvm.thread-count";
        private int threadLoad = -1;
        public static final String Key$threadLoad = "wings.slardar.monitor.jvm.thread-load";

        @Generated
        public Rule() {
        }

        @Generated
        public int getSystemCent() {
            return this.systemCent;
        }

        @Generated
        public int getSystemLoad() {
            return this.systemLoad;
        }

        @Generated
        public int getProcessCent() {
            return this.processCent;
        }

        @Generated
        public int getProcessLoad() {
            return this.processLoad;
        }

        @Generated
        public int getMemoryLoad() {
            return this.memoryLoad;
        }

        @Generated
        public int getThreadCount() {
            return this.threadCount;
        }

        @Generated
        public int getThreadLoad() {
            return this.threadLoad;
        }

        @Generated
        public void setSystemCent(int systemCent) {
            this.systemCent = systemCent;
        }

        @Generated
        public void setSystemLoad(int systemLoad) {
            this.systemLoad = systemLoad;
        }

        @Generated
        public void setProcessCent(int processCent) {
            this.processCent = processCent;
        }

        @Generated
        public void setProcessLoad(int processLoad) {
            this.processLoad = processLoad;
        }

        @Generated
        public void setMemoryLoad(int memoryLoad) {
            this.memoryLoad = memoryLoad;
        }

        @Generated
        public void setThreadCount(int threadCount) {
            this.threadCount = threadCount;
        }

        @Generated
        public void setThreadLoad(int threadLoad) {
            this.threadLoad = threadLoad;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Rule)) {
                return false;
            }
            Rule other = (Rule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSystemCent() != other.getSystemCent()) {
                return false;
            }
            if (this.getSystemLoad() != other.getSystemLoad()) {
                return false;
            }
            if (this.getProcessCent() != other.getProcessCent()) {
                return false;
            }
            if (this.getProcessLoad() != other.getProcessLoad()) {
                return false;
            }
            if (this.getMemoryLoad() != other.getMemoryLoad()) {
                return false;
            }
            if (this.getThreadCount() != other.getThreadCount()) {
                return false;
            }
            return this.getThreadLoad() == other.getThreadLoad();
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Rule;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSystemCent();
            result = result * 59 + this.getSystemLoad();
            result = result * 59 + this.getProcessCent();
            result = result * 59 + this.getProcessLoad();
            result = result * 59 + this.getMemoryLoad();
            result = result * 59 + this.getThreadCount();
            result = result * 59 + this.getThreadLoad();
            return result;
        }

        @NotNull
        @Generated
        public String toString() {
            return "JvmMetric.Rule(systemCent=" + this.getSystemCent() + ", systemLoad=" + this.getSystemLoad() + ", processCent=" + this.getProcessCent() + ", processLoad=" + this.getProcessLoad() + ", memoryLoad=" + this.getMemoryLoad() + ", threadCount=" + this.getThreadCount() + ", threadLoad=" + this.getThreadLoad() + ")";
        }
    }
}

