/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.notice;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import okhttp3.Call;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import pro.fessional.mirana.text.JsonTemplate;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.silencer.notice.SmallNotice;
import pro.fessional.wings.slardar.httprest.okhttp.OkHttpClientHelper;
import pro.fessional.wings.slardar.notice.DingTalkConf;
import pro.fessional.wings.slardar.spring.prop.SlardarDingNoticeProp;

public class DingTalkNotice
implements SmallNotice<DingTalkConf>,
InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DingTalkNotice.class);
    @NotNull
    private final Call.Factory callFactory;
    @NotNull
    private final SlardarDingNoticeProp configProp;
    private Executor executor;
    private List<DingTalkConf.Loader> configLoader = Collections.emptyList();

    @NotNull
    public DingTalkConf defaultConfig() {
        return this.configProp.getDefault();
    }

    public DingTalkConf combineConfig(@Nullable DingTalkConf that) {
        DingTalkConf newConf = new DingTalkConf();
        newConf.adopt(that);
        newConf.merge(this.configProp.getDefault());
        return newConf;
    }

    @Contract(value="_,true->!null")
    public DingTalkConf provideConfig(@Nullable String name, boolean combine) {
        if (name == null || name.isEmpty()) {
            return this.defaultConfig();
        }
        DingTalkConf conf = (DingTalkConf)this.configProp.get(name);
        if (conf == null && this.configLoader != null) {
            for (DingTalkConf.Loader ld : this.configLoader) {
                DingTalkConf cf = ld.load(name);
                if (cf == null) continue;
                conf = cf;
                break;
            }
        }
        if (combine) {
            return this.combineConfig(conf);
        }
        return conf;
    }

    public boolean send(DingTalkConf config, String subject, String content) {
        Object host;
        if (subject == null && content == null) {
            return false;
        }
        if (config == null) {
            config = this.defaultConfig();
        }
        if ((host = config.getValidWebhook()) == null) {
            log.warn("skip bad webhookUrl={}, AccessToken={}", (Object)config.getWebhookUrl(), (Object)config.getAccessToken());
            return false;
        }
        String digestSecret = config.getDigestSecret();
        if (digestSecret != null && !digestSecret.isEmpty()) {
            long now = ThreadNow.millis();
            String stringToSign = now + "\n" + digestSecret;
            Mac hmacSHA256 = Mac.getInstance("HmacSHA256");
            hmacSHA256.init(new SecretKeySpec(digestSecret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            byte[] signData = hmacSHA256.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
            hmacSHA256.reset();
            String sign = URLEncoder.encode(new String(Base64.encodeBase64((byte[])signData)), StandardCharsets.UTF_8);
            host = (String)host + "&timestamp=" + now + "&sign=" + sign;
        }
        String message = "markdown".equalsIgnoreCase(config.getMsgType()) ? this.buildMarkdown(config, subject, content) : this.buildText(config, subject, content);
        log.debug("ding-talk post message, host={}, text={}", host, (Object)message);
        String dr = config.getDryrun();
        if (dr != null && !dr.isEmpty() && subject.startsWith(dr)) {
            log.info("ding-talk dryrun. subject={}, message={}", (Object)subject, (Object)message);
            return true;
        }
        String s = OkHttpClientHelper.postJson(this.callFactory, (String)host, (CharSequence)message);
        log.debug("ding-talk result={}", (Object)s);
        return s.contains("\"errcode\":0,");
    }

    public boolean post(DingTalkConf config, String subject, String content) {
        try {
            return this.send(config, subject, content);
        }
        catch (Exception e) {
            log.error("failed to post dingtalk notice", (Throwable)e);
            return false;
        }
    }

    public void emit(DingTalkConf config, String subject, String content) {
        this.executor.execute(() -> this.send(config, subject, content));
    }

    public void afterPropertiesSet() {
        if (this.executor == null) {
            log.warn("should reuse autowired thread pool");
            this.executor = Executors.newSingleThreadExecutor();
        }
    }

    public String buildText(DingTalkConf conf, String subject, String content) {
        return JsonTemplate.obj(t -> t.putVal("msgtype", (Object)"text").putObj("text", o -> o.putVal("content", (Object)this.buildContent(conf, content, subject))).putObj("at", o -> this.buildNotice(conf, (JsonTemplate.Obj)o)));
    }

    public String buildMarkdown(DingTalkConf conf, String subject, String content) {
        return JsonTemplate.obj(t -> t.putVal("msgtype", (Object)"markdown").putObj("markdown", o -> o.putVal("title", (Object)(subject != null ? subject : "untitled")).putVal("text", (Object)this.buildContent(conf, content, subject))).putObj("at", o -> this.buildNotice(conf, (JsonTemplate.Obj)o)));
    }

    private String buildContent(DingTalkConf conf, String main, String title) {
        String kw;
        if (main == null) {
            main = "";
        }
        StringBuilder buff = new StringBuilder();
        if (title != null && !main.contains(title)) {
            buff.append("# ").append(title).append("\n\n").append(main);
        }
        if ((kw = conf.getNoticeKeyword()) != null && !kw.isEmpty() && !main.contains(kw)) {
            buff.append('\n').append(kw);
        }
        for (String mb : conf.getNoticeMobiles().values()) {
            if (main.contains(mb)) continue;
            buff.append(" @").append(mb);
        }
        return buff.isEmpty() ? main : buff.toString();
    }

    private void buildNotice(DingTalkConf conf, JsonTemplate.Obj obj) {
        if (conf.getNoticeMobiles().isEmpty()) {
            obj.putVal("isAtAll", (Object)true);
        } else {
            obj.putArr("atMobiles", conf.getNoticeMobiles().values());
        }
    }

    @Generated
    public DingTalkNotice(@NotNull Call.Factory callFactory, @NotNull SlardarDingNoticeProp configProp) {
        if (callFactory == null) {
            throw new NullPointerException("callFactory is marked non-null but is null");
        }
        if (configProp == null) {
            throw new NullPointerException("configProp is marked non-null but is null");
        }
        this.callFactory = callFactory;
        this.configProp = configProp;
    }

    @Autowired(required=false)
    @Qualifier(value="taskScheduler")
    @Generated
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Autowired(required=false)
    @Generated
    public void setConfigLoader(List<DingTalkConf.Loader> configLoader) {
        this.configLoader = configLoader;
    }

    @Generated
    public List<DingTalkConf.Loader> getConfigLoader() {
        return this.configLoader;
    }
}

