/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import com.alibaba.ttl.threadpool.TtlExecutors;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.task.TaskSchedulingProperties;
import org.springframework.boot.task.TaskExecutorBuilder;
import org.springframework.boot.task.TaskSchedulerBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ConcurrentTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.async.TaskSchedulerHelper;
import pro.fessional.wings.slardar.async.TtlThreadPoolTaskScheduler;
import pro.fessional.wings.slardar.spring.prop.SlardarAsyncProp;

@EnableAsync
@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class SlardarAsyncConfiguration {
    public static final String slardarHeavyScheduler = "slardarHeavyScheduler";
    private static final Log log = LogFactory.getLog(SlardarAsyncConfiguration.class);

    @Bean(name={"taskExecutor"})
    @ConditionalWingsEnabled
    public Executor taskExecutor(TaskExecutorBuilder builder) {
        ThreadPoolTaskExecutor executor = builder.build();
        executor.initialize();
        log.info((Object)("Slardar spring-bean taskExecutor via ttlExecutor, prefix=" + executor.getThreadNamePrefix()));
        return TtlExecutors.getTtlExecutor((Executor)executor);
    }

    @Bean(name={"applicationTaskExecutor"})
    @ConditionalWingsEnabled
    public AsyncTaskExecutor applicationTaskExecutor(TaskExecutorBuilder builder) {
        ThreadPoolTaskExecutor executor = builder.build();
        executor.initialize();
        Executor ttlExecutor = TtlExecutors.getTtlExecutor((Executor)executor);
        log.info((Object)("Slardar spring-bean applicationTaskExecutor via ttlExecutor, prefix=" + executor.getThreadNamePrefix()));
        return new ConcurrentTaskExecutor(ttlExecutor);
    }

    @Bean(name={"taskScheduler"})
    @ConditionalWingsEnabled
    public ThreadPoolTaskScheduler taskScheduler(TaskSchedulerBuilder builder) {
        TtlThreadPoolTaskScheduler scheduler = new TtlThreadPoolTaskScheduler();
        TtlThreadPoolTaskScheduler bean = (TtlThreadPoolTaskScheduler)builder.configure((ThreadPoolTaskScheduler)scheduler);
        log.info((Object)("Slardar spring-bean taskScheduler via TtlThreadPoolTaskScheduler, prefix=" + bean.getThreadNamePrefix()));
        return bean;
    }

    @Bean(name={"slardarHeavyScheduler"})
    @ConditionalWingsEnabled
    public ThreadPoolTaskScheduler slardarHeavyScheduler(SlardarAsyncProp prop) {
        TtlThreadPoolTaskScheduler scheduler = new TtlThreadPoolTaskScheduler();
        TaskSchedulerBuilder builder = new TaskSchedulerBuilder();
        TaskSchedulingProperties heavy = prop.getHeavy();
        builder = builder.poolSize(heavy.getPool().getSize());
        TaskSchedulingProperties.Shutdown shutdown = heavy.getShutdown();
        builder = builder.awaitTermination(shutdown.isAwaitTermination());
        builder = builder.awaitTerminationPeriod(shutdown.getAwaitTerminationPeriod());
        builder = builder.threadNamePrefix(heavy.getThreadNamePrefix());
        log.info((Object)("Slardar spring-bean slardarHeavyScheduler via TtlThreadPoolTaskExecutor, prefix=" + heavy.getThreadNamePrefix()));
        return builder.configure((ThreadPoolTaskScheduler)scheduler);
    }

    @Bean
    @ConditionalWingsEnabled
    public TaskSchedulerHelper taskSchedulerHelper(@Qualifier(value="taskScheduler") ThreadPoolTaskScheduler light, @Qualifier(value="slardarHeavyScheduler") ThreadPoolTaskScheduler heavy) {
        log.info((Object)"Slardar spring-bean taskSchedulerHelper");
        return new TaskSchedulerHelper(this, light, heavy){};
    }
}

