/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import pro.fessional.wings.silencer.runner.ApplicationStartedEventRunner;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.autodto.AutoDtoHelper;
import pro.fessional.wings.slardar.autodto.AutoZoneVisitor;
import pro.fessional.wings.slardar.autodto.I18nStringVisitor;
import pro.fessional.wings.slardar.context.LocaleZoneIdUtil;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class SlardarI18nConfiguration {
    private static final Log log = LogFactory.getLog(SlardarI18nConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public LocalValidatorFactoryBean localValidatorFactoryBean(MessageSource messageSource) {
        log.info((Object)"Slardar spring-bean localValidatorFactoryBean");
        LocalValidatorFactoryBean bean = new LocalValidatorFactoryBean();
        bean.setValidationMessageSource(messageSource);
        return bean;
    }

    @Bean
    @ConditionalWingsEnabled
    public ApplicationStartedEventRunner autoDtoHelperRunner(final MessageSource messageSource) {
        log.info((Object)"Slardar spring-runs autoDtoHelperRunner");
        return new ApplicationStartedEventRunner(-90000000, ignored -> new AutoDtoHelper(this){
            {
                I18nStringVisitor i18nStringVisitor = new I18nStringVisitor(messageSource, LocaleZoneIdUtil.LocaleNonnull);
                RequestVisitor.add(AutoDtoHelper.AutoDtoVisitor);
                RequestVisitor.add(new AutoZoneVisitor(LocaleZoneIdUtil.ZoneIdNonnull, true));
                log.info((Object)"Slardar conf addRequestVisitor AutoZoneVisitorRequest");
                RequestVisitor.add(i18nStringVisitor);
                log.info((Object)"Slardar conf addRequestVisitor I18nStringVisitor");
                ResponseVisitor.add(AutoDtoHelper.AutoDtoVisitor);
                ResponseVisitor.add(new AutoZoneVisitor(LocaleZoneIdUtil.ZoneIdNonnull, false));
                log.info((Object)"Slardar conf addResponseVisitor AutoZoneVisitorResponse");
                ResponseVisitor.add(i18nStringVisitor);
                log.info((Object)"Slardar conf addResponseVisitor I18nStringVisitor");
            }
        });
    }
}

