/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import java.io.File;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.util.unit.DataSize;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.monitor.MonitorTask;
import pro.fessional.wings.slardar.monitor.metric.JvmMetric;
import pro.fessional.wings.slardar.monitor.metric.LogMetric;
import pro.fessional.wings.slardar.monitor.report.DingTalkReport;
import pro.fessional.wings.slardar.notice.DingTalkNotice;
import pro.fessional.wings.slardar.spring.prop.SlardarMonitorProp;

@EnableScheduling
@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class SlardarMonitorConfiguration {
    private static final Log log = LogFactory.getLog(SlardarMonitorConfiguration.class);

    @Bean
    @ConditionalWingsEnabled(abs="wings.enabled.slardar.monitor-jvm")
    public JvmMetric jvmMonitor(SlardarMonitorProp prop) {
        log.info((Object)"Slardar spring-bean jvmMonitor");
        JvmMetric.Rule rule = prop.getJvm();
        return new JvmMetric(rule);
    }

    @Bean
    @ConditionalWingsEnabled
    public DingTalkReport dingTalkReport(DingTalkNotice dingTalkNotice, SlardarMonitorProp prop) {
        String name = prop.getDingNotice();
        log.info((Object)("Slardar spring-bean dingTalkReport, conf=" + name));
        return new DingTalkReport(dingTalkNotice, name);
    }

    @Bean
    @ConditionalWingsEnabled
    public MonitorTask monitorTask(SlardarMonitorProp prop) {
        log.info((Object)"Slardar spring-bean monitorTask");
        MonitorTask bean = new MonitorTask();
        bean.setHookSelf(prop.isHook());
        return bean;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalWingsEnabled(abs="wings.enabled.slardar.monitor-log")
    @ComponentScan(basePackageClasses={MonitorTask.class})
    public static class LogMonitor
    implements BeanFactoryPostProcessor,
    EnvironmentAware {
        private SlardarMonitorProp slardarMonitorProp;

        public void setEnvironment(@NotNull Environment environment) {
            log.info((Object)"Slardar spring-bind SlardarMonitorProp");
            this.slardarMonitorProp = (SlardarMonitorProp)Binder.get((Environment)environment).bind("wings.slardar.monitor", SlardarMonitorProp.class).orElseGet(SlardarMonitorProp::new);
        }

        public void postProcessBeanFactory(@NotNull ConfigurableListableBeanFactory beanFactory) throws BeansException {
            log.info((Object)"Slardar spring-proc LogMonitor beans");
            Map<String, LogMetric.Rule> logs = this.slardarMonitorProp.getLog();
            LogMetric.Rule defaults = logs.get("default");
            for (Map.Entry<String, LogMetric.Rule> entry : logs.entrySet()) {
                String key = "wings.slardar.monitor.log." + entry.getKey();
                if (beanFactory.containsBean(key)) {
                    log.info((Object)("Slardar skip LogMonitor bean=" + key + ", for existed"));
                    continue;
                }
                LogMetric.Rule rule = entry.getValue();
                if (rule.isEnable()) {
                    this.fillDefault(defaults, rule);
                    String rf = rule.getFile();
                    if (new File(rf).exists()) {
                        LogMetric bean = new LogMetric(key, rule);
                        beanFactory.registerSingleton(key, (Object)bean);
                        log.info((Object)("Slardar spring-bean register dynamic LogMonitor bean=" + key));
                        continue;
                    }
                    log.warn((Object)("Slardar skip LogMonitor bean for file not exist, bean=" + key + ", file=" + rf));
                    continue;
                }
                log.info((Object)("Wings skip LogMonitor bean=" + key + ", for disabled"));
            }
        }

        private void fillDefault(LogMetric.Rule def, LogMetric.Rule use) {
            if (use.getMinGrow() == null) {
                use.setMinGrow(def == null ? DataSize.ofBytes((long)1L) : def.getMinGrow());
            }
            if (use.getMaxGrow() == null) {
                use.setMaxGrow(def == null ? DataSize.ofMegabytes((long)10L) : def.getMaxGrow());
            }
            if (use.getMaxSize() == null) {
                use.setMaxSize(def == null ? DataSize.ofGigabytes((long)1L) : def.getMaxSize());
            }
            if (use.getCharset() == null) {
                use.setCharset(def == null ? "UTF8" : def.getCharset());
            }
        }
    }
}

