/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.async;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.task.ThreadPoolTaskExecutorBuilder;
import org.springframework.core.task.AsyncTaskExecutor;

public class AsyncHelper
implements DisposableBean {
    private static Executor AsyncExecutor = null;
    private static AsyncTaskExecutor AppTaskExecutor = null;
    private static ThreadPoolTaskExecutorBuilder ExecutorBuilder;
    private static AsyncTaskExecutor LiteExecutor;
    private static boolean helperPrepared;

    protected AsyncHelper(@NotNull Executor async, @NotNull AsyncTaskExecutor appTask, @NotNull ThreadPoolTaskExecutorBuilder builder, @NotNull AsyncTaskExecutor lite) {
        AsyncExecutor = Objects.requireNonNull(async);
        AppTaskExecutor = Objects.requireNonNull(appTask);
        ExecutorBuilder = Objects.requireNonNull(builder);
        LiteExecutor = Objects.requireNonNull(lite);
        helperPrepared = true;
    }

    public void destroy() {
        helperPrepared = false;
    }

    public static boolean isPrepared() {
        return helperPrepared;
    }

    @NotNull
    public static Executor Async() {
        if (AsyncExecutor == null) {
            throw new IllegalStateException("AsyncExecutor must init before using");
        }
        return AsyncExecutor;
    }

    public static CompletableFuture<Void> Async(@NotNull Runnable task) {
        return CompletableFuture.runAsync(task, AsyncExecutor);
    }

    public static <T> CompletableFuture<T> Async(@NotNull Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(supplier, AsyncExecutor);
    }

    @NotNull
    public static AsyncTaskExecutor AppTask() {
        if (AppTaskExecutor == null) {
            throw new IllegalStateException("AppTaskExecutor must init before using");
        }
        return AppTaskExecutor;
    }

    @NotNull
    public static AsyncTaskExecutor Lite() {
        if (LiteExecutor == null) {
            throw new IllegalStateException("LiteExecutor must init before using");
        }
        return LiteExecutor;
    }

    @NotNull
    public static ThreadPoolTaskExecutorBuilder ExecutorBuilder() {
        if (ExecutorBuilder == null) {
            throw new IllegalStateException("LightBuilder must init before using");
        }
        return ExecutorBuilder;
    }

    static {
        helperPrepared = false;
    }
}

