/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.async;

import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.task.ThreadPoolTaskSchedulerBuilder;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.slardar.async.TtlThreadPoolTaskScheduler;

public class TaskSchedulerHelper
implements DisposableBean {
    private static ThreadPoolTaskScheduler FastScheduler;
    private static ThreadPoolTaskScheduler ScheduledScheduler;
    private static ThreadPoolTaskSchedulerBuilder FastBuilder;
    private static ThreadPoolTaskSchedulerBuilder ScheduledBuilder;
    private static boolean helperPrepared;
    private static final ConcurrentHashMap<Long, ScheduledFuture<?>> TaskRun;
    private static final AtomicLong TaskSeq;

    protected TaskSchedulerHelper(@NotNull ThreadPoolTaskScheduler fast, @NotNull ThreadPoolTaskScheduler scheduled, @NotNull ThreadPoolTaskSchedulerBuilder fastBuilder, @NotNull ThreadPoolTaskSchedulerBuilder scheduledBuilder) {
        FastScheduler = Objects.requireNonNull(fast);
        ScheduledScheduler = Objects.requireNonNull(scheduled);
        FastBuilder = Objects.requireNonNull(fastBuilder);
        ScheduledBuilder = Objects.requireNonNull(scheduledBuilder);
        helperPrepared = true;
    }

    public void destroy() {
        helperPrepared = false;
        for (ScheduledFuture<?> task : TaskRun.values()) {
            task.cancel(false);
        }
        TaskRun.clear();
    }

    public static boolean isPrepared() {
        return helperPrepared;
    }

    public static TtlThreadPoolTaskScheduler Ttl(ThreadPoolTaskSchedulerBuilder builder) {
        return (TtlThreadPoolTaskScheduler)builder.configure((ThreadPoolTaskScheduler)new TtlThreadPoolTaskScheduler());
    }

    @NotNull
    public static ThreadPoolTaskScheduler Scheduler(boolean fast) {
        return fast ? TaskSchedulerHelper.Fast() : TaskSchedulerHelper.Scheduled();
    }

    @NotNull
    public static ThreadPoolTaskScheduler Fast() {
        if (FastScheduler == null) {
            throw new IllegalStateException("FastScheduler must init before using");
        }
        return FastScheduler;
    }

    @NotNull
    public static ThreadPoolTaskScheduler Scheduled() {
        if (ScheduledScheduler == null) {
            throw new IllegalStateException("ScheduledScheduler must init before using");
        }
        return ScheduledScheduler;
    }

    public static void Scheduled(@NotNull Runnable task) {
        TaskSchedulerHelper.Scheduled().execute(task);
    }

    @NotNull
    public static ScheduledFuture<?> Scheduled(long delayMs, @NotNull Runnable task) {
        return TaskSchedulerHelper.Scheduled(TaskSchedulerHelper.Scheduled(), delayMs, task);
    }

    @NotNull
    public static ScheduledFuture<?> Scheduled(@NotNull Instant start, @NotNull Runnable task) {
        return TaskSchedulerHelper.Scheduled(TaskSchedulerHelper.Scheduled(), start, task);
    }

    @Nullable
    public static ScheduledFuture<?> Scheduled(@NotNull Trigger trigger, @NotNull Runnable task) {
        return TaskSchedulerHelper.Scheduled(TaskSchedulerHelper.Scheduled(), trigger, task);
    }

    public static void Scheduled(boolean fast, @NotNull Runnable task) {
        TaskSchedulerHelper.Scheduler(fast).execute(task);
    }

    @NotNull
    public static ScheduledFuture<?> Scheduled(boolean fast, long delayMs, @NotNull Runnable task) {
        return TaskSchedulerHelper.Scheduled(TaskSchedulerHelper.Scheduler(fast), delayMs, task);
    }

    @NotNull
    public static ScheduledFuture<?> Scheduled(boolean fast, @NotNull Instant start, @NotNull Runnable task) {
        return TaskSchedulerHelper.Scheduled(TaskSchedulerHelper.Scheduler(fast), start, task);
    }

    @Nullable
    public static ScheduledFuture<?> Scheduled(boolean fast, @NotNull Trigger trigger, @NotNull Runnable task) {
        return TaskSchedulerHelper.Scheduled(TaskSchedulerHelper.Scheduler(fast), trigger, task);
    }

    @NotNull
    public static ScheduledFuture<?> Scheduled(@NotNull ThreadPoolTaskScheduler scheduler, long delayMs, @NotNull Runnable task) {
        return TaskSchedulerHelper.Scheduled(scheduler, Instant.ofEpochMilli(ThreadNow.millis() + delayMs), task);
    }

    @NotNull
    public static ScheduledFuture<?> Scheduled(@NotNull ThreadPoolTaskScheduler scheduler, @NotNull Instant start, @NotNull Runnable task) {
        Task tsk = new Task(task);
        ScheduledFuture future = scheduler.schedule((Runnable)tsk, start);
        if (tsk.run) {
            TaskRun.put(tsk.seq, future);
        }
        return future;
    }

    @Nullable
    public static ScheduledFuture<?> Scheduled(@NotNull ThreadPoolTaskScheduler scheduler, @NotNull Trigger trigger, @NotNull Runnable task) {
        Task tsk = new Task(task);
        ScheduledFuture future = scheduler.schedule((Runnable)tsk, trigger);
        if (future != null && tsk.run) {
            TaskRun.put(tsk.seq, future);
        }
        return future;
    }

    public static int runningSize() {
        TaskRun.entrySet().removeIf(en -> ((ScheduledFuture)en.getValue()).isDone());
        return TaskRun.size();
    }

    @NotNull
    public static ThreadPoolTaskSchedulerBuilder FastBuilder() {
        if (FastBuilder == null) {
            throw new IllegalStateException("FastBuilder must init before using");
        }
        return FastBuilder;
    }

    @NotNull
    public static ThreadPoolTaskSchedulerBuilder ScheduledBuilder() {
        if (ScheduledBuilder == null) {
            throw new IllegalStateException("ScheduledBuilder must init before using");
        }
        return ScheduledBuilder;
    }

    static {
        helperPrepared = false;
        TaskRun = new ConcurrentHashMap();
        TaskSeq = new AtomicLong(0L);
    }

    private static class Task
    implements Runnable {
        private final Long seq = TaskSeq.incrementAndGet();
        private volatile boolean run = true;
        private final Runnable runnable;

        public Task(Runnable run) {
            this.runnable = run;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            finally {
                this.run = false;
                TaskRun.remove(this.seq);
            }
        }
    }
}

