/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.autozone.json;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import pro.fessional.mirana.time.DateParser;

public class JacksonLocalDateDeserializer
extends LocalDateDeserializer {
    private final List<DateTimeFormatter> formats;

    public JacksonLocalDateDeserializer(DateTimeFormatter dtf, List<DateTimeFormatter> formats) {
        super(dtf);
        this.formats = formats;
    }

    public JacksonLocalDateDeserializer(LocalDateDeserializer base, DateTimeFormatter dtf, List<DateTimeFormatter> formats) {
        super(base, dtf);
        this.formats = formats;
    }

    protected JacksonLocalDateDeserializer(LocalDateDeserializer base, Boolean leniency, List<DateTimeFormatter> formats) {
        super(base, leniency);
        this.formats = formats;
    }

    protected JacksonLocalDateDeserializer(LocalDateDeserializer base, JsonFormat.Shape shape, List<DateTimeFormatter> formats) {
        super(base, shape);
        this.formats = formats;
    }

    protected LocalDateDeserializer withDateFormat(DateTimeFormatter dtf) {
        if (dtf == this._formatter) {
            return this;
        }
        ArrayList<DateTimeFormatter> fts = new ArrayList<DateTimeFormatter>(this.formats.size());
        fts.add(dtf);
        fts.addAll(this.formats);
        return new JacksonLocalDateDeserializer((LocalDateDeserializer)this, dtf, fts);
    }

    protected LocalDateDeserializer withLeniency(Boolean leniency) {
        return new JacksonLocalDateDeserializer((LocalDateDeserializer)this, leniency, this.formats);
    }

    protected LocalDateDeserializer withShape(JsonFormat.Shape shape) {
        return new JacksonLocalDateDeserializer((LocalDateDeserializer)this, shape, this.formats);
    }

    public LocalDate deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        TemporalAccessor tma = DateParser.parseTemporal((CharSequence)parser.getText(), this.formats, (boolean)true);
        if (tma == null) {
            return super.deserialize(parser, context);
        }
        LocalDate ldt = (LocalDate)tma.query(DateParser.QueryDate);
        return ldt != null ? ldt : super.deserialize(parser, context);
    }
}

