/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.autozone.json;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.time.DateParser;
import pro.fessional.wings.slardar.autozone.AutoTimeZone;
import pro.fessional.wings.slardar.autozone.AutoZoneAware;
import pro.fessional.wings.slardar.autozone.AutoZoneType;

public class JacksonLocalDateTimeDeserializer
extends LocalDateTimeDeserializer
implements AutoZoneAware {
    private final List<DateTimeFormatter> formats;
    private AutoZoneType autoZone;

    public JacksonLocalDateTimeDeserializer(DateTimeFormatter formatter, List<DateTimeFormatter> formats, boolean auto) {
        this(formatter, formats, AutoZoneType.valueOf(auto));
    }

    public JacksonLocalDateTimeDeserializer(DateTimeFormatter formatter, List<DateTimeFormatter> formats, AutoZoneType auto) {
        super(formatter);
        this.formats = formats;
        this.autoZone = auto;
    }

    public LocalDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        TemporalAccessor tma = DateParser.parseTemporal((CharSequence)parser.getText(), this.formats, (boolean)true);
        if (tma != null) {
            return this.autoLocalRequest(tma, this.autoZone);
        }
        return super.deserialize(parser, context);
    }

    protected JacksonLocalDateTimeDeserializer(LocalDateTimeDeserializer base, Boolean leniency, List<DateTimeFormatter> formats) {
        super(base, leniency);
        this.formats = formats;
    }

    protected JacksonLocalDateTimeDeserializer withDateFormat(DateTimeFormatter dtf) {
        if (dtf == this._formatter) {
            return this;
        }
        ArrayList<DateTimeFormatter> fts = new ArrayList<DateTimeFormatter>(this.formats.size());
        fts.add(dtf);
        fts.addAll(this.formats);
        return new JacksonLocalDateTimeDeserializer(dtf, fts, this.autoZone);
    }

    protected JacksonLocalDateTimeDeserializer withLeniency(Boolean leniency) {
        return new JacksonLocalDateTimeDeserializer(this, leniency, this.formats);
    }

    protected JacksonLocalDateTimeDeserializer withShape(JsonFormat.Shape shape) {
        return this;
    }

    public JacksonLocalDateTimeDeserializer createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        AutoTimeZone anno;
        JacksonLocalDateTimeDeserializer dsr = (JacksonLocalDateTimeDeserializer)super.createContextual(ctxt, property);
        if (property != null && (anno = (AutoTimeZone)property.getAnnotation(AutoTimeZone.class)) != null) {
            dsr.autoZone = anno.value();
        }
        return dsr;
    }

    @NotNull
    public JacksonLocalDateTimeDeserializer autoOff() {
        return new JacksonLocalDateTimeDeserializer(this._formatter, this.formats, AutoZoneType.Off);
    }
}

