/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.autozone.json;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.time.DateParser;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.slardar.autozone.AutoTimeZone;
import pro.fessional.wings.slardar.autozone.AutoZoneAware;
import pro.fessional.wings.slardar.autozone.AutoZoneType;

public class JacksonOffsetDateTimeDeserializer
extends InstantDeserializer<OffsetDateTime>
implements AutoZoneAware {
    private final List<DateTimeFormatter> formats;
    private AutoZoneType autoZone;

    public JacksonOffsetDateTimeDeserializer(DateTimeFormatter formatter, List<DateTimeFormatter> formats, boolean auto) {
        this(formatter, formats, AutoZoneType.valueOf(auto));
    }

    public JacksonOffsetDateTimeDeserializer(DateTimeFormatter formatter, List<DateTimeFormatter> formats, AutoZoneType auto) {
        super(OffsetDateTime.class, formatter, temporal -> DateParser.parseOffset((TemporalAccessor)temporal, (ZoneId)(auto == AutoZoneType.Off ? null : ThreadNow.sysZoneId())), a -> OffsetDateTime.ofInstant(Instant.ofEpochMilli(a.value), a.zoneId), a -> OffsetDateTime.ofInstant(Instant.ofEpochSecond(a.integer, a.fraction), a.zoneId), (zonedDateTime, zoneId) -> zonedDateTime, false);
        this.formats = formats;
        this.autoZone = auto;
    }

    public OffsetDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        TemporalAccessor tma = DateParser.parseTemporal((CharSequence)parser.getText(), this.formats, (boolean)true);
        if (tma != null) {
            return this.autoOffsetRequest(tma, this.autoZone);
        }
        return (OffsetDateTime)super.deserialize(parser, context);
    }

    protected JacksonOffsetDateTimeDeserializer(JacksonOffsetDateTimeDeserializer jacksonZonedDeserializer, Boolean leniency, List<DateTimeFormatter> formats, AutoZoneType auto) {
        super((InstantDeserializer)jacksonZonedDeserializer, leniency);
        this.formats = formats;
        this.autoZone = auto;
    }

    protected JacksonOffsetDateTimeDeserializer withDateFormat(DateTimeFormatter dtf) {
        if (dtf == this._formatter) {
            return this;
        }
        ArrayList<DateTimeFormatter> fts = new ArrayList<DateTimeFormatter>(this.formats.size());
        fts.add(dtf);
        fts.addAll(this.formats);
        return new JacksonOffsetDateTimeDeserializer(dtf, fts, this.autoZone);
    }

    protected JacksonOffsetDateTimeDeserializer withLeniency(Boolean leniency) {
        return new JacksonOffsetDateTimeDeserializer(this, leniency, this.formats, this.autoZone);
    }

    protected JacksonOffsetDateTimeDeserializer withShape(JsonFormat.Shape shape) {
        return this;
    }

    public JacksonOffsetDateTimeDeserializer createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        AutoTimeZone anno;
        JacksonOffsetDateTimeDeserializer dsr = (JacksonOffsetDateTimeDeserializer)super.createContextual(ctxt, property);
        if (property != null && (anno = (AutoTimeZone)property.getAnnotation(AutoTimeZone.class)) != null) {
            dsr.autoZone = anno.value();
        }
        return dsr;
    }

    @NotNull
    public JacksonOffsetDateTimeDeserializer autoOff() {
        return new JacksonOffsetDateTimeDeserializer(this._formatter, this.formats, AutoZoneType.Off);
    }
}

