/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.autozone.json;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.ser.ZonedDateTimeSerializer;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.jetbrains.annotations.NotNull;
import pro.fessional.wings.slardar.autozone.AutoTimeZone;
import pro.fessional.wings.slardar.autozone.AutoZoneAware;
import pro.fessional.wings.slardar.autozone.AutoZoneType;

public class JacksonZonedDateTimeSerializer
extends ZonedDateTimeSerializer
implements AutoZoneAware {
    public static DateTimeFormatter defaultFormatter = DateTimeFormatter.ofPattern("yyyy[-MM][-dd][ ][HH][:mm][:ss][ ][VV]");
    public static AutoZoneType defaultAutoZone = AutoZoneType.Off;
    private AutoZoneType autoZone;

    public JacksonZonedDateTimeSerializer() {
        this(defaultFormatter, defaultAutoZone);
    }

    public JacksonZonedDateTimeSerializer(DateTimeFormatter formatter, AutoZoneType auto) {
        super(formatter);
        this.autoZone = auto;
    }

    public void serialize(ZonedDateTime value, JsonGenerator g, SerializerProvider provider) throws IOException {
        super.serialize(this.autoZonedResponse(value, this.autoZone), g, provider);
    }

    protected JacksonZonedDateTimeSerializer(ZonedDateTimeSerializer base, Boolean useTimestamp, Boolean useNanoseconds, DateTimeFormatter formatter, JsonFormat.Shape shape, Boolean writeZoneId, AutoZoneType auto) {
        super(base, useTimestamp, useNanoseconds, formatter, shape, writeZoneId);
        this.autoZone = auto;
    }

    protected JacksonZonedDateTimeSerializer withFormat(Boolean useTimestamp, DateTimeFormatter formatter, JsonFormat.Shape shape) {
        return new JacksonZonedDateTimeSerializer(this, useTimestamp, this._useNanoseconds, formatter, shape, this._writeZoneId, this.autoZone);
    }

    protected JacksonZonedDateTimeSerializer withFeatures(Boolean writeZoneId, Boolean writeNanoseconds) {
        return new JacksonZonedDateTimeSerializer(this, this._useTimestamp, writeNanoseconds, this._formatter, this._shape, writeZoneId, this.autoZone);
    }

    public JacksonZonedDateTimeSerializer createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        AutoTimeZone anno;
        JacksonZonedDateTimeSerializer ser = (JacksonZonedDateTimeSerializer)super.createContextual(prov, property);
        if (property != null && (anno = (AutoTimeZone)property.getAnnotation(AutoTimeZone.class)) != null) {
            ser.autoZone = anno.value();
        }
        return ser;
    }

    @NotNull
    public JacksonZonedDateTimeSerializer autoOff() {
        return new AutoOff();
    }

    public static class AutoOff
    extends JacksonZonedDateTimeSerializer {
        public AutoOff() {
            super(defaultFormatter, AutoZoneType.Off);
        }

        public AutoOff(DateTimeFormatter formatter) {
            super(formatter, AutoZoneType.Off);
        }
    }
}

