/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.cache;

import java.util.function.Supplier;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.SimpleKeyGenerator;
import org.springframework.core.convert.converter.Converter;
import pro.fessional.mirana.best.AssertArgs;
import pro.fessional.wings.silencer.spring.help.ApplicationContextHelper;

public class SimpleCacheTemplate<T> {
    private final String manager;
    private final String[] names;
    private final Cache[] caches;
    private volatile int status;
    private volatile Converter<T, Object> encoder = null;
    private volatile Converter<Object, T> decoder = null;
    private volatile BeanFactory beanFactory = null;

    public SimpleCacheTemplate(@NotNull String manager, String ... caches) {
        this.manager = manager;
        this.names = caches;
        this.caches = new Cache[caches.length];
        this.status = -1;
    }

    public SimpleCacheTemplate(Cache ... caches) {
        this.manager = null;
        this.names = null;
        this.caches = caches;
        this.status = 1;
    }

    @Contract(value="_->this")
    public SimpleCacheTemplate<T> setEncoder(@Nullable Converter<T, Object> encoder) {
        this.encoder = encoder;
        return this;
    }

    @Contract(value="_->this")
    public SimpleCacheTemplate<T> setDecoder(@Nullable Converter<Object, T> decoder) {
        this.decoder = decoder;
        return this;
    }

    @Contract(value="_->this")
    public SimpleCacheTemplate<T> setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.status = -1;
        return this;
    }

    public T getArgKey(Object ... args) {
        return this.getRawKey(this.rawKey(args));
    }

    public T getRawKey(@NotNull Object key) {
        for (Cache cache : this.getCaches()) {
            Cache.ValueWrapper vw = cache.get(key);
            if (vw == null || vw.get() == null) continue;
            return this.decode(vw.get());
        }
        return null;
    }

    public T getArgKey(@NotNull Supplier<T> value, Object ... args) {
        return this.getRawKey(value, this.rawKey(args));
    }

    public T getRawKey(@NotNull Supplier<T> value, @NotNull Object key) {
        for (Cache cache : this.getCaches()) {
            Cache.ValueWrapper vw = cache.get(key);
            if (vw == null || vw.get() == null) continue;
            return this.decode(vw.get());
        }
        T v = value.get();
        if (v != null) {
            this.putRawKey(v, key);
        }
        return v;
    }

    public <U> U getArgKey(@NotNull Converter<T, U> converter, Object ... args) {
        return this.getRawKey(converter, this.rawKey(args));
    }

    public <U> U getRawKey(@NotNull Converter<T, U> converter, @NotNull Object key) {
        T t = this.getRawKey(key);
        return (U)converter.convert(t);
    }

    public <U> U getArgKey(@NotNull Converter<T, U> converter, @NotNull Supplier<T> value, Object ... args) {
        return this.getRawKey(converter, value, this.rawKey(args));
    }

    public <U> U getRawKey(@NotNull Converter<T, U> converter, @NotNull Supplier<T> value, @NotNull Object key) {
        T t = this.getRawKey(value, key);
        return (U)converter.convert(t);
    }

    public void putArgKey(@NotNull T value, Object ... args) {
        this.putRawKey(value, this.rawKey(args));
    }

    public void putRawKey(@NotNull T value, @NotNull Object key) {
        Object obj = this.encode(value);
        for (Cache cache : this.getCaches()) {
            cache.put(key, obj);
        }
    }

    public T putArgKeyIfPresent(@NotNull T value, Object ... args) {
        return this.putRawKeyIfPresent(value, this.rawKey(args));
    }

    public T putRawKeyIfPresent(@NotNull T value, @NotNull Object key) {
        Object obj = this.encode(value);
        Cache.ValueWrapper vw = null;
        for (Cache cache : this.getCaches()) {
            vw = cache.putIfAbsent(key, obj);
        }
        return vw == null ? null : (T)this.decode(vw.get());
    }

    public <U> U putArgKeyIfPresent(@NotNull Converter<T, U> converter, @NotNull T value, Object ... args) {
        return this.putRawKeyIfPresent(converter, value, this.rawKey(args));
    }

    public <U> U putRawKeyIfPresent(@NotNull Converter<T, U> converter, @NotNull T value, @NotNull Object key) {
        T t = this.putRawKeyIfPresent(value, key);
        return (U)converter.convert(t);
    }

    public void evictArgKey(Object ... args) {
        this.evictRawKey(this.rawKey(args));
    }

    public void evictRawKey(@NotNull Object key) {
        for (Cache cache : this.getCaches()) {
            cache.evict(key);
        }
    }

    public void evictAll() {
        for (Cache cache : this.getCaches()) {
            cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cache[] getCaches() {
        if (this.status != -1) return this.caches;
        Cache[] cacheArray = this.caches;
        synchronized (this.caches) {
            if (this.status == -1) {
                AssertArgs.notNull((Object)this.manager, (String)"empty manager={}", (Object[])new Object[]{this.manager});
                CacheManager cacheManager = this.beanFactory == null ? (CacheManager)ApplicationContextHelper.getBean((String)this.manager) : (CacheManager)this.beanFactory.getBean(this.manager, CacheManager.class);
                AssertArgs.notNull((Object)cacheManager, (String)"cacheManager not found, manager={}", (Object[])new Object[]{this.manager});
                AssertArgs.notNull((Object)this.names, (String)"cache is null");
                for (int i = 0; i < this.names.length; ++i) {
                    this.caches[i] = cacheManager.getCache(this.names[i]);
                    AssertArgs.notNull((Object)this.caches[i], (String)"cache not found,name={}, manager={}", (Object[])new Object[]{this.names[i], this.manager});
                }
            }
            this.status = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.caches;
        }
    }

    public T decode(Object obj) {
        return (T)(this.decoder == null ? obj : this.decoder.convert(obj));
    }

    public Object encode(T obj) {
        return this.encoder == null ? obj : this.encoder.convert(obj);
    }

    public Object rawKey(Object ... args) {
        return SimpleKeyGenerator.generateKey((Object[])args);
    }

    @Generated
    public Converter<T, Object> getEncoder() {
        return this.encoder;
    }

    @Generated
    public Converter<Object, T> getDecoder() {
        return this.decoder;
    }

    @Generated
    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }
}

