/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.cache;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.CacheOperation;
import pro.fessional.mirana.best.AssertState;

public class WingsCacheHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WingsCacheHelper.class);
    private static final Map<String, CacheManager> NameManager = new ConcurrentHashMap<String, CacheManager>();
    private static final Map<CacheManager, Set<String>> ManagerName = new ConcurrentHashMap<CacheManager, Set<String>>();
    private static CacheManager MemoryManager = null;
    private static CacheManager ServerManager = null;
    private static boolean helperPrepared = false;
    private static final Map<Class<?>, Map<String, Meta>> ClassCacheMeta = new ConcurrentHashMap();

    protected WingsCacheHelper(Map<String, CacheManager> mngs) {
        NameManager.putAll(mngs);
        MemoryManager = NameManager.get("MemoryCacheManager");
        ServerManager = NameManager.get("ServerCacheManager");
        ManagerName.clear();
        for (Map.Entry<String, CacheManager> en : NameManager.entrySet()) {
            ManagerName.computeIfAbsent(en.getValue(), k -> new HashSet()).add(en.getKey());
        }
        helperPrepared = true;
    }

    public static boolean isPrepared() {
        return helperPrepared;
    }

    @Nullable
    public static CacheManager getCacheManager(String name) {
        if ("MemoryCacheManager".equalsIgnoreCase(name)) {
            return MemoryManager;
        }
        if ("ServerCacheManager".equalsIgnoreCase(name)) {
            return ServerManager;
        }
        return NameManager.get(name);
    }

    public static Set<String> getManagerNames(CacheManager manage) {
        if (manage == null) {
            return Collections.emptySet();
        }
        return ManagerName.getOrDefault(manage, Collections.emptySet());
    }

    @Nullable
    public static Cache getCache(String manager, String cache) {
        CacheManager cm = WingsCacheHelper.getCacheManager(manager);
        return cm == null ? null : cm.getCache(cache);
    }

    @NotNull
    public static Cache getMemoryCache(String name) {
        Cache cache = MemoryManager.getCache(name);
        AssertState.notNull((Object)cache, (String)"memory cache is null, name={}", (Object[])new Object[]{name});
        return cache;
    }

    @NotNull
    public static Cache getServerCache(String name) {
        Cache cache = ServerManager.getCache(name);
        AssertState.notNull((Object)cache, (String)"server cache is null, name={}", (Object[])new Object[]{name});
        return cache;
    }

    @NotNull
    public static CacheManager getMemory() {
        AssertState.notNull((Object)MemoryManager, (String)"Memory CacheManager is null");
        return MemoryManager;
    }

    @NotNull
    public static CacheManager getServer() {
        AssertState.notNull((Object)ServerManager, (String)"Server CacheManager is null");
        return ServerManager;
    }

    @NotNull
    public static Map<String, Set<String>> getCacheMeta(Class<?> clz) {
        return WingsCacheHelper.getCacheMeta(clz, "");
    }

    @NotNull
    public static Map<String, Set<String>> getCacheMeta(Class<?> claz, String method) {
        Meta mt;
        Map<String, Meta> map = ClassCacheMeta.get(claz);
        if (map == null) {
            return Collections.emptyMap();
        }
        if (method == null) {
            method = "";
        }
        return (mt = map.get(method)) == null ? Collections.emptyMap() : mt.MngRlvCache;
    }

    @NotNull
    public static Map<CacheManager, Set<String>> getManager(Class<?> clz) {
        return WingsCacheHelper.getManager(clz, "");
    }

    @NotNull
    public static Map<CacheManager, Set<String>> getManager(Class<?> claz, String method) {
        Meta mt;
        Map<String, Meta> map = ClassCacheMeta.get(claz);
        if (map == null) {
            return Collections.emptyMap();
        }
        if (method == null) {
            method = "";
        }
        return (mt = map.get(method)) == null ? Collections.emptyMap() : mt.getManagers();
    }

    @NotNull
    public static Map<String, Set<Cache>> getCaches(Class<?> clz) {
        return WingsCacheHelper.getCaches(clz, "");
    }

    @NotNull
    public static Map<String, Set<Cache>> getCaches(Class<?> claz, String method) {
        Meta mt;
        Map<String, Meta> map = ClassCacheMeta.get(claz);
        if (map == null) {
            return Collections.emptyMap();
        }
        if (method == null) {
            method = "";
        }
        return (mt = map.get(method)) == null ? Collections.emptyMap() : mt.getCaches();
    }

    public static void prepareOperation(Method method, Collection<CacheOperation> opr) {
        if (opr == null || opr.isEmpty()) {
            return;
        }
        Map entry = ClassCacheMeta.computeIfAbsent(method.getDeclaringClass(), k -> new ConcurrentHashMap());
        Meta top = entry.computeIfAbsent("", k -> new Meta());
        Meta mod = entry.computeIfAbsent(method.getName(), k -> new Meta());
        for (CacheOperation op : opr) {
            String cr = op.getCacheResolver();
            String cm = op.getCacheManager();
            Set cs = op.getCacheNames();
            top.initOperation(cr, cm, cs);
            mod.initOperation(cr, cm, cs);
        }
    }

    public static class Meta {
        private final Map<String, Set<String>> MngRlvCache = new HashMap<String, Set<String>>();
        private final Map<CacheManager, Set<String>> managerName = new HashMap<CacheManager, Set<String>>();
        private final Map<String, Set<Cache>> managerCache = new HashMap<String, Set<Cache>>();

        public void initOperation(String cr, String cm, Set<String> cs) {
            if (!cr.isEmpty()) {
                this.MngRlvCache.computeIfAbsent(cr, k -> new HashSet()).addAll(cs);
            }
            if (!cm.isEmpty()) {
                this.MngRlvCache.computeIfAbsent(cm, k -> new HashSet()).addAll(cs);
            }
        }

        public Map<CacheManager, Set<String>> getManagers() {
            if (this.MngRlvCache.isEmpty()) {
                return this.managerName;
            }
            if (this.managerName.isEmpty()) {
                for (String nm : this.MngRlvCache.keySet()) {
                    CacheManager m = WingsCacheHelper.getCacheManager(nm);
                    AssertState.notNull((Object)m, (String)"no CacheManager for {}", (Object[])new Object[]{nm});
                    this.managerName.put(m, WingsCacheHelper.getManagerNames(m));
                }
            }
            return this.managerName;
        }

        public Map<String, Set<Cache>> getCaches() {
            if (this.MngRlvCache.isEmpty()) {
                return this.managerCache;
            }
            if (this.managerCache.isEmpty()) {
                for (Map.Entry<String, Set<String>> en : this.MngRlvCache.entrySet()) {
                    String k = en.getKey();
                    CacheManager m = WingsCacheHelper.getCacheManager(k);
                    AssertState.notNull((Object)m, (String)"no CacheManager for {}", (Object[])new Object[]{k});
                    HashSet<Cache> st = new HashSet<Cache>();
                    for (String c : en.getValue()) {
                        st.add(m.getCache(c));
                    }
                    this.managerCache.put(k, st);
                }
            }
            return this.managerCache;
        }
    }
}

