/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.cache.cache2k;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import lombok.Generated;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.cache2k.config.CacheBuildContext;
import org.cache2k.config.Feature;
import org.cache2k.extra.spring.SpringCache2kCache;
import org.cache2k.extra.spring.SpringCache2kCacheManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.wings.slardar.cache.WingsCache;
import pro.fessional.wings.slardar.cache.cache2k.NullsCache2k;
import pro.fessional.wings.slardar.cache.cache2k.WingsCache2k;
import pro.fessional.wings.slardar.spring.prop.SlardarCacheProp;

public class WingsCache2kManager
extends SpringCache2kCacheManager
implements WingsCache.State {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WingsCache2kManager.class);
    private final SlardarCacheProp slardarCacheProp;
    private final ConcurrentHashMap<String, NullsCache2k> nullsCache = new ConcurrentHashMap();
    private final Feature levelingFeature;
    private Function<Cache2kBuilder<?, ?>, Cache2kBuilder<?, ?>> defaultSetup = null;

    public WingsCache2kManager(String name, final SlardarCacheProp slardarCacheProp) {
        super(name == null ? "springDefault" : name);
        this.slardarCacheProp = slardarCacheProp;
        this.levelingFeature = new Feature(){

            public <K, V> void enlist(@NotNull CacheBuildContext<K, V> ctx) {
                String name = ctx.getName();
                Cache2kBuilder bld = ctx.getConfig().builder();
                for (Map.Entry<String, SlardarCacheProp.Conf> entry : slardarCacheProp.getLevel().entrySet()) {
                    String key = entry.getKey();
                    if (!WingsCache.Naming.inLevel(name, key)) continue;
                    SlardarCacheProp.Conf level = entry.getValue();
                    WingsCache2k.builder(bld, level.getMaxSize(), level.getMaxLive(), level.getMaxIdle(), false);
                    log.info("Wings Cache2k name={}, level={}", (Object)name, (Object)key);
                    return;
                }
                SlardarCacheProp.Conf common = slardarCacheProp.getCommon();
                WingsCache2k.builder(bld, common.getMaxSize(), common.getMaxLive(), common.getMaxIdle(), false);
                log.info("Wings Cache2k name={}, level=default", (Object)name);
            }
        };
        super.defaultSetup(this::levelingBuilder);
        super.setAllowUnknownCache(true);
    }

    @NotNull
    public SpringCache2kCacheManager defaultSetup(@NotNull Function<Cache2kBuilder<?, ?>, Cache2kBuilder<?, ?>> f) {
        this.defaultSetup = f;
        return this;
    }

    @NotNull
    public SpringCache2kCache getCache(@NotNull String name) {
        int size = this.slardarCacheProp.getNullSize();
        if (size < 0) {
            return super.getCache(name);
        }
        return this.nullsCache.computeIfAbsent(name, k -> {
            SpringCache2kCache cache = super.getCache(k);
            return new NullsCache2k((Cache<Object, Object>)cache.getNativeCache(), size, this.slardarCacheProp.getNullLive());
        });
    }

    protected Cache2kBuilder<?, ?> levelingBuilder(@NotNull Cache2kBuilder<?, ?> builder) {
        if (this.defaultSetup != null) {
            this.defaultSetup.apply(builder);
        }
        if (WingsCache2k.FeatureJmx != null) {
            builder.enable(WingsCache2k.FeatureJmx);
        }
        builder.config().getFeatures().add(this.levelingFeature);
        return builder;
    }

    @Override
    @NotNull
    public Map<String, Integer> statsCacheSize() {
        TreeMap<String, Integer> stats = new TreeMap<String, Integer>();
        Map cacheMap = super.getCacheMap();
        for (Map.Entry en : cacheMap.entrySet()) {
            SpringCache2kCache cache = (SpringCache2kCache)en.getValue();
            stats.put((String)en.getKey(), cache == null ? -1 : cache.getNativeCache().entries().size());
        }
        return stats;
    }

    @Override
    @NotNull
    public Set<Object> statsCacheKeys(String name) {
        SpringCache2kCache cache = this.getCache(name);
        return cache.getNativeCache().keys();
    }
}

