/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.cache.spring;

import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.springframework.cache.Cache;
import pro.fessional.mirana.best.DummyBlock;
import pro.fessional.wings.slardar.cache.cache2k.WingsCache2k;

public class NullsCache
implements Cache {
    private final Cache backend;
    private final org.cache2k.Cache<Object, Object> nulls;

    public NullsCache(Cache cache, int size, int live) {
        this.backend = cache;
        this.nulls = size > 0 ? WingsCache2k.builder(NullsCache.class, "nulls", size, live, 0).build() : null;
    }

    @NotNull
    public String getName() {
        return this.backend.getName();
    }

    @NotNull
    public Object getNativeCache() {
        return this.backend.getNativeCache();
    }

    public Cache.ValueWrapper get(@NotNull Object key) {
        if (this.nulls != null && this.nulls.get(key) != null) {
            return null;
        }
        return this.backend.get(key);
    }

    public <T> T get(@NotNull Object key, Class<T> type) {
        if (this.nulls != null && this.nulls.get(key) != null) {
            return null;
        }
        return (T)this.backend.get(key, type);
    }

    public <T> T get(@NotNull Object key, @NotNull Callable<T> valueLoader) {
        if (this.nulls != null && this.nulls.get(key) != null) {
            return null;
        }
        Object value = this.backend.get(key, valueLoader);
        if (value == null && this.nulls != null) {
            this.nulls.put(key, (Object)Boolean.TRUE);
        }
        return (T)value;
    }

    public void put(@NotNull Object key, Object value) {
        if (value == null) {
            if (this.nulls != null) {
                this.nulls.put(key, (Object)Boolean.TRUE);
            } else {
                DummyBlock.empty();
            }
        } else {
            this.backend.put(key, value);
        }
    }

    public void evict(@NotNull Object key) {
        this.backend.evict(key);
        if (this.nulls != null) {
            this.nulls.remove(key);
        }
    }

    public void clear() {
        this.backend.clear();
        if (this.nulls != null) {
            this.nulls.removeAll();
        }
    }
}

