/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.context;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.best.TypedReg;
import pro.fessional.wings.slardar.context.AttributeCache;

public class AttributeHolder {
    public static final int TtlDefault = 43200;
    private static final ConcurrentHashMap<TypedReg<?, ?>, AttributeCache<?, ?>> Holder = new ConcurrentHashMap();

    @NotNull
    public static <K, V> AttributeCache<K, V> getCache(@NotNull TypedReg<K, V> reg) {
        return Holder.computeIfAbsent(reg, k -> {
            AttributeCache cache = new AttributeCache(AttributeHolder.class, reg, 0, 43200, 0);
            cache.register();
            return cache;
        });
    }

    @NotNull
    public static Set<TypedReg<?, ?>> holders() {
        return new HashSet(Holder.keySet());
    }

    public static <K, V> void regLoader(@NotNull TypedReg<K, V> reg, @NotNull Function<K, V> loader) {
        AttributeHolder.getCache(reg).setLoader(loader);
    }

    public static <K, V> void putAttr(@NotNull TypedReg<K, V> reg, @NotNull K key, @NotNull V value) {
        AttributeHolder.getCache(reg).putAttr(key, value);
    }

    public static <K, V> void putAttr(@NotNull TypedReg<K, V> reg, @NotNull K key, @NotNull V value, int ttl) {
        AttributeHolder.getCache(reg).putAttr(key, value, ttl);
    }

    public static <K, V> void putAttrs(@NotNull TypedReg<K, V> reg, @NotNull Map<K, V> map) {
        AttributeHolder.getCache(reg).putAttrs(map);
    }

    public static <K, V> void putAttrs(@NotNull TypedReg<K, V> reg, @NotNull Map<K, V> map, int ttl) {
        AttributeHolder.getCache(reg).putAttrs(map, ttl);
    }

    @Contract(value="_,_,!null->!null")
    public static <K, V> V tryAttr(@NotNull TypedReg<K, V> reg, @NotNull K key, V elze) {
        return AttributeHolder.getCache(reg).tryAttr(key, elze);
    }

    @Contract(value="_,_,!null,_->!null")
    public static <K, V> V tryAttr(@NotNull TypedReg<K, V> reg, @NotNull K key, V elze, int ttl) {
        return AttributeHolder.getCache(reg).tryAttr(key, elze, ttl);
    }

    @NotNull
    public static <K, V> V tryAttr(@NotNull TypedReg<K, V> reg, @NotNull K key) {
        return AttributeHolder.getCache(reg).tryAttr(key);
    }

    @NotNull
    public static <K, V> V tryAttr(@NotNull TypedReg<K, V> reg, @NotNull K key, int ttl) {
        return AttributeHolder.getCache(reg).tryAttr(key, ttl);
    }

    @Contract(value="_,_,true ->!null")
    public static <K, V> V tryAttr(@NotNull TypedReg<K, V> reg, @NotNull K key, boolean notnull) {
        return AttributeHolder.getCache(reg).tryAttr(key, notnull);
    }

    @Contract(value="_,_,true,_ ->!null")
    public static <K, V> V tryAttr(@NotNull TypedReg<K, V> reg, @NotNull K key, boolean notnull, int ttl) {
        return AttributeHolder.getCache(reg).tryAttr(key, notnull, ttl);
    }

    @Nullable
    public static <K, V> V getAttr(@NotNull TypedReg<K, V> reg, @NotNull K key) {
        AttributeCache<?, ?> cache = Holder.get(reg);
        return cache == null ? null : (V)cache.getAttr(key);
    }

    @NotNull
    public static <K, V> Map<K, V> getAttrs(@NotNull TypedReg<K, V> reg, @NotNull Collection<K> key) {
        AttributeCache<?, ?> cache = Holder.get(reg);
        return cache == null ? Collections.emptyMap() : cache.getAttrs(key);
    }

    public static <K> void ridAttr(TypedReg<K, ?> reg, K key) {
        AttributeCache<?, ?> cache = Holder.get(reg);
        if (cache != null) {
            cache.ridAttr(key);
        }
    }

    public static <K> void ridAttrs(TypedReg<K, ?> reg, Collection<? extends K> key) {
        if (key == null || key.isEmpty()) {
            return;
        }
        AttributeCache<?, ?> cache = Holder.get(reg);
        if (cache != null) {
            cache.ridAttrs(key);
        }
    }

    public static void ridAttrAll(TypedReg<?, ?> ... reg) {
        if (reg == null || reg.length == 0) {
            return;
        }
        AttributeHolder.ridAttrAll(Arrays.asList(reg));
    }

    public static void ridAttrAll(Collection<? extends TypedReg<?, ?>> reg) {
        if (reg == null || reg.isEmpty()) {
            return;
        }
        for (TypedReg<?, ?> tr : reg) {
            AttributeCache<?, ?> cache = Holder.get(tr);
            if (cache == null) continue;
            cache.ridAttrAll();
        }
    }

    public static void ridLoader(TypedReg<?, ?> ... reg) {
        if (reg == null || reg.length == 0) {
            return;
        }
        AttributeHolder.ridLoader(Arrays.asList(reg));
    }

    public static void ridLoader(Collection<? extends TypedReg<?, ?>> reg) {
        if (reg == null || reg.isEmpty()) {
            return;
        }
        for (TypedReg<?, ?> tr : reg) {
            AttributeCache<?, ?> cache = Holder.get(tr);
            if (cache == null) continue;
            cache.setLoader(null);
        }
    }

    public static void unregister(TypedReg<?, ?> ... reg) {
        for (TypedReg<?, ?> tr : reg) {
            AttributeCache<?, ?> cache = Holder.get(tr);
            if (cache == null) continue;
            cache.unregister();
        }
    }
}

