/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.fastjson;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.Filter;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.TypeDescriptor;
import pro.fessional.mirana.lock.ArrayKey;
import pro.fessional.wings.silencer.support.TypeSugar;

public class FastJsonHelper {
    public static final JSONReader.Feature[] WingsReader = new JSONReader.Feature[]{JSONReader.Feature.SupportSmartMatch, JSONReader.Feature.UseNativeObject, JSONReader.Feature.IgnoreSetNullValue, JSONReader.Feature.ErrorOnNotSupportAutoType, JSONReader.Feature.AllowUnQuotedFieldNames};
    public static final JSONWriter.Feature[] WingsWriter = new JSONWriter.Feature[]{JSONWriter.Feature.WriteEnumsUsingName, JSONWriter.Feature.WriteBigDecimalAsPlain, JSONWriter.Feature.BrowserCompatible};
    public static final JSONPath.Feature[] WingsPath = new JSONPath.Feature[]{JSONPath.Feature.NullOnError};
    public static final long WingsPathMask = FastJsonHelper.featureMask(WingsPath);
    private static final ConcurrentHashMap<ArrayKey, JSONPath> JsonPathCache = new ConcurrentHashMap();

    @Contract(value="!null,_->!null")
    public static <T> T object(String json, @NotNull ResolvableType targetType) {
        if (json == null) {
            return null;
        }
        return (T)JSON.parseObject((String)json, (Type)targetType.getType(), (JSONReader.Feature[])WingsReader);
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(String json, @NotNull TypeDescriptor targetType) {
        if (json == null) {
            return null;
        }
        return (T)JSON.parseObject((String)json, (Type)targetType.getResolvableType().getType(), (JSONReader.Feature[])WingsReader);
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(String json, @NotNull Type targetType) {
        if (json == null) {
            return null;
        }
        return (T)JSON.parseObject((String)json, (Type)targetType, (JSONReader.Feature[])WingsReader);
    }

    @Contract(value="!null,_,_->!null")
    public static <T> T object(String json, @NotNull Class<?> targetType, Class<?> ... generics) {
        if (json == null) {
            return null;
        }
        Type genericType = TypeSugar.type(targetType, (Class[])generics);
        return (T)JSON.parseObject((String)json, (Type)genericType, (JSONReader.Feature[])WingsReader);
    }

    @Contract(value="!null->!null")
    public static JSONObject object(String json) {
        if (json == null) {
            return null;
        }
        return JSON.parseObject((String)json, (JSONReader.Feature[])WingsReader);
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(InputStream json, @NotNull ResolvableType targetType) {
        if (json == null) {
            return null;
        }
        return (T)JSON.parseObject((InputStream)json, (Type)targetType.getType(), (JSONReader.Feature[])WingsReader);
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(InputStream json, @NotNull TypeDescriptor targetType) {
        if (json == null) {
            return null;
        }
        return (T)JSON.parseObject((InputStream)json, (Type)targetType.getResolvableType().getType(), (JSONReader.Feature[])WingsReader);
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(InputStream json, @NotNull Type targetType) {
        if (json == null) {
            return null;
        }
        return (T)JSON.parseObject((InputStream)json, (Type)targetType, (JSONReader.Feature[])WingsReader);
    }

    @Contract(value="!null,_,_->!null")
    public static <T> T object(InputStream json, @NotNull Class<?> targetType, Class<?> ... generics) {
        if (json == null) {
            return null;
        }
        Type genericType = TypeSugar.type(targetType, (Class[])generics);
        return (T)JSON.parseObject((InputStream)json, (Type)genericType, (JSONReader.Feature[])WingsReader);
    }

    @Contract(value="!null->!null")
    public static JSONObject object(InputStream json) {
        if (json == null) {
            return null;
        }
        return JSON.parseObject((InputStream)json, (JSONReader.Feature[])WingsReader);
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(byte[] json, @NotNull ResolvableType targetType) {
        if (json == null) {
            return null;
        }
        return (T)JSON.parseObject((byte[])json, (Type)targetType.getType(), (JSONReader.Feature[])WingsReader);
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(byte[] json, @NotNull TypeDescriptor targetType) {
        if (json == null) {
            return null;
        }
        return (T)JSON.parseObject((byte[])json, (Type)targetType.getResolvableType().getType(), (JSONReader.Feature[])WingsReader);
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(byte[] json, @NotNull Type targetType) {
        if (json == null) {
            return null;
        }
        return (T)JSON.parseObject((byte[])json, (Type)targetType, (JSONReader.Feature[])WingsReader);
    }

    @Contract(value="!null,_,_->!null")
    public static <T> T object(byte[] json, @NotNull Class<?> targetType, Class<?> ... generics) {
        if (json == null) {
            return null;
        }
        Type genericType = TypeSugar.type(targetType, (Class[])generics);
        return (T)JSON.parseObject((byte[])json, (Type)genericType, (JSONReader.Feature[])WingsReader);
    }

    @Contract(value="!null->!null")
    public static JSONObject object(byte[] json) {
        if (json == null) {
            return null;
        }
        return JSON.parseObject((byte[])json, (JSONReader.Feature[])WingsReader);
    }

    @Contract(value="!null->!null")
    public static String string(Object obj) {
        if (obj == null) {
            return null;
        }
        return JSON.toJSONString((Object)obj, (JSONWriter.Feature[])WingsWriter);
    }

    @Contract(value="!null->!null")
    public static byte[] bytes(Object obj) {
        if (obj == null) {
            return null;
        }
        return JSON.toJSONBytes((Object)obj, (JSONWriter.Feature[])WingsWriter);
    }

    @Contract(value="!null,_->!null")
    public static String string(Object obj, Filter ... filters) {
        if (obj == null) {
            return null;
        }
        return JSON.toJSONString((Object)obj, (Filter[])filters, (JSONWriter.Feature[])WingsWriter);
    }

    @Contract(value="!null,_->!null")
    public static byte[] bytes(Object obj, Filter ... filters) {
        if (obj == null) {
            return null;
        }
        return JSON.toJSONBytes((Object)obj, (Filter[])filters, (JSONWriter.Feature[])WingsWriter);
    }

    public static JSONPath path(@NotNull String path) {
        return FastJsonHelper.path(path, null, WingsPath);
    }

    public static JSONPath path(@NotNull String path, Type type) {
        return FastJsonHelper.path(path, type, WingsPath);
    }

    public static JSONPath path(@NotNull String path, Class<?> type, Class<?> ... generics) {
        Type genericType = TypeSugar.type(type, (Class[])generics);
        return FastJsonHelper.path(path, genericType, WingsPath);
    }

    public static JSONPath path(@NotNull String path, Type type, JSONPath.Feature ... features) {
        ArrayKey key = new ArrayKey(new Object[]{path, type, features});
        return JsonPathCache.computeIfAbsent(key, ignore -> JSONPath.of((String)path, (Type)type, (JSONPath.Feature[])features));
    }

    public static JSONPath path(@NotNull String[] paths, Type[] types, JSONPath.Feature ... features) {
        return FastJsonHelper.path(paths, types, features, WingsReader);
    }

    public static JSONPath path(@NotNull String[] paths, Type[] types, JSONPath.Feature[] pathFeatures, JSONReader.Feature ... features) {
        ArrayKey key = new ArrayKey(new Object[]{paths, types, pathFeatures, features});
        long[] pfs = FastJsonHelper.features(paths.length, pathFeatures);
        return JsonPathCache.computeIfAbsent(key, ignore -> JSONPath.of((String[])paths, (Type[])types, null, (long[])pfs, null, (JSONReader.Feature[])features));
    }

    public static long[] features(int size, JSONPath.Feature ... features) {
        if (size <= 0) {
            return null;
        }
        long mask = FastJsonHelper.featureMask(features);
        return FastJsonHelper.features(size, mask);
    }

    public static long featureMask(JSONPath.Feature ... features) {
        if (features == null || features.length == 0) {
            return WingsPathMask;
        }
        long ft = 0L;
        for (JSONPath.Feature f : features) {
            ft |= f.mask;
        }
        return ft;
    }

    private static long @Nullable [] features(int size, long features) {
        long[] pts = new long[size];
        Arrays.fill(pts, features);
        return pts;
    }

    @Contract(value="_,_,!null->!null")
    public static String getString(JSONObject node, String field, String defaults) {
        if (node == null) {
            return defaults;
        }
        String jn = node.getString(field);
        return jn != null ? jn : defaults;
    }

    public static boolean getBoolean(JSONObject node, String field, boolean defaults) {
        if (node == null) {
            return defaults;
        }
        Boolean jn = node.getBoolean(field);
        return jn != null ? jn : defaults;
    }

    public static int getInt(JSONObject node, String field, int defaults) {
        if (node == null) {
            return defaults;
        }
        Integer jn = node.getInteger(field);
        return jn != null ? jn : defaults;
    }

    public static long getLong(JSONObject node, String field, long defaults) {
        if (node == null) {
            return defaults;
        }
        Long jn = node.getLong(field);
        return jn != null ? jn : defaults;
    }

    public static double getDouble(JSONObject node, String field, double defaults) {
        if (node == null) {
            return defaults;
        }
        Double jn = node.getDouble(field);
        return jn != null ? jn : defaults;
    }
}

