/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.fastjson.filter;

import com.alibaba.fastjson2.filter.PropertyFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ComposePropertyFilter
implements PropertyFilter {
    private final boolean delta;
    private final boolean andOr;
    private final List<PropertyFilter> filters;

    public ComposePropertyFilter(boolean andOr, PropertyFilter ... filters) {
        this(true, andOr, Arrays.asList(filters));
    }

    public ComposePropertyFilter(boolean delta, boolean andOr, PropertyFilter ... filters) {
        this(delta, andOr, Arrays.asList(filters));
    }

    public ComposePropertyFilter(boolean andOr, @NotNull Collection<? extends PropertyFilter> filters) {
        this(true, andOr, filters);
    }

    public ComposePropertyFilter(boolean delta, boolean andOr, @NotNull Collection<? extends PropertyFilter> filters) {
        this.delta = delta;
        this.andOr = andOr;
        this.filters = filters instanceof List ? (List<Object>)filters : new ArrayList<PropertyFilter>(filters);
    }

    public boolean apply(Object object, String name, Object value) {
        for (PropertyFilter ft : this.filters) {
            boolean b = ft.apply(object, name, value);
            if (this.andOr) {
                if (b) continue;
                return false;
            }
            if (!b) continue;
            return true;
        }
        return this.delta;
    }
}

