/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.httprest.okhttp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.BiFunction;
import okhttp3.Call;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpMethod;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.util.function.SingletonSupplier;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.io.InputStreams;
import pro.fessional.mirana.pain.IORuntimeException;
import pro.fessional.wings.silencer.spring.help.ApplicationContextHelper;
import pro.fessional.wings.slardar.httprest.okhttp.OkHttpBuildableClient;
import pro.fessional.wings.slardar.httprest.okhttp.OkHttpClientBuilder;
import pro.fessional.wings.slardar.httprest.okhttp.OkHttpMediaType;

public class OkHttpClientHelper {
    private static final SingletonSupplier<OkHttpClient> SpringClient = ApplicationContextHelper.getSingletonSupplier(OkHttpClient.class, OkHttpClientHelper::staticClient);
    public static final RequestBody EMPTY = RequestBody.create((String)"", (MediaType)OkHttpMediaType.ALL_VALUE);

    @NotNull
    public static OkHttpClient staticClient() {
        return DefaultClientHolder.DefaultClient;
    }

    @NotNull
    public static OkHttpClient springClient() {
        return (OkHttpClient)SpringClient.obtain();
    }

    @NotNull
    public static MultipartBody.Builder postFile(@NotNull String key, @NotNull File file) {
        return new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart(key, file.getName(), RequestBody.create((File)file, (MediaType)OkHttpMediaType.MULTIPART_FORM_DATA_VALUE));
    }

    @NotNull
    public static MultipartBody.Builder postFile(@NotNull String key, byte @NotNull [] file, @NotNull String fileName) {
        return new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart(key, fileName, RequestBody.create((byte[])file, (MediaType)OkHttpMediaType.MULTIPART_FORM_DATA_VALUE));
    }

    @NotNull
    public static MultipartBody.Builder postFile(@NotNull String key, @NotNull InputStream file, @NotNull String fileName) {
        return OkHttpClientHelper.postFile(key, InputStreams.readBytes((InputStream)file), fileName);
    }

    @NotNull
    public static String postFile(@NotNull OkHttpClient client, @NotNull String url, @NotNull String key, @NotNull File file) {
        return OkHttpClientHelper.postFile((Call.Factory)client, url, OkHttpClientHelper.postFile(key, file).build());
    }

    @NotNull
    public static String postFile(@NotNull Call.Factory callFactory, @NotNull String url, @NotNull String key, @NotNull File file) {
        return OkHttpClientHelper.postFile(callFactory, url, OkHttpClientHelper.postFile(key, file).build());
    }

    @NotNull
    public static String postFile(@NotNull OkHttpClient client, @NotNull String url, @NotNull String key, byte @NotNull [] file, @NotNull String fileName) {
        return OkHttpClientHelper.postFile((Call.Factory)client, url, OkHttpClientHelper.postFile(key, file, fileName).build());
    }

    @NotNull
    public static String postFile(@NotNull Call.Factory callFactory, @NotNull String url, @NotNull String key, byte @NotNull [] file, @NotNull String fileName) {
        return OkHttpClientHelper.postFile(callFactory, url, OkHttpClientHelper.postFile(key, file, fileName).build());
    }

    @NotNull
    public static String postFile(@NotNull OkHttpClient client, @NotNull String url, @NotNull String key, @NotNull InputStream file, @NotNull String fileName) {
        return OkHttpClientHelper.postFile((Call.Factory)client, url, OkHttpClientHelper.postFile(key, file, fileName).build());
    }

    @NotNull
    public static String postFile(@NotNull Call.Factory callFactory, @NotNull String url, @NotNull String key, @NotNull InputStream file, @NotNull String fileName) {
        return OkHttpClientHelper.postFile(callFactory, url, OkHttpClientHelper.postFile(key, file, fileName).build());
    }

    @NotNull
    public static String postFile(@NotNull OkHttpClient client, @NotNull String url, @NotNull MultipartBody body) {
        return OkHttpClientHelper.postFile((Call.Factory)client, url, body);
    }

    @NotNull
    public static String postFile(@NotNull Call.Factory callFactory, @NotNull String url, @NotNull MultipartBody body) {
        String string;
        block8: {
            Request.Builder builder = new Request.Builder().url(url).post((RequestBody)body);
            Response response = OkHttpClientHelper.execute(callFactory, builder);
            try {
                string = OkHttpClientHelper.extractString(response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("failed to post file, url=" + url, e);
                }
            }
            response.close();
        }
        return string;
    }

    @NotNull
    public static String postJson(@NotNull OkHttpClient client, @NotNull String url, @Nullable CharSequence json) {
        return OkHttpClientHelper.executeJson(client, url, json, "POST");
    }

    @NotNull
    public static String postJson(@NotNull Call.Factory callFactory, @NotNull String url, @Nullable CharSequence json) {
        return OkHttpClientHelper.executeJson(callFactory, url, json, "POST");
    }

    @Nullable
    public static ResponseBody extract(@Nullable Response response) {
        return response == null ? null : response.body();
    }

    @NotNull
    public static String extractString(@Nullable Response response) throws IOException {
        ResponseBody body = OkHttpClientHelper.extract(response);
        return OkHttpClientHelper.extractString(body);
    }

    @Nullable
    @Contract(value="_,false->!null")
    public static String extractString(@Nullable Response response, boolean nullWhenThrow) {
        ResponseBody body = OkHttpClientHelper.extract(response);
        return OkHttpClientHelper.extractString(body, nullWhenThrow);
    }

    @NotNull
    public static String extractString(@Nullable ResponseBody body) throws IOException {
        if (body == null) {
            return "";
        }
        return body.string();
    }

    @Nullable
    @Contract(value="_,false->!null")
    public static String extractString(@Nullable ResponseBody body, boolean nullWhenThrow) {
        try {
            return OkHttpClientHelper.extractString(body);
        }
        catch (Exception e) {
            if (nullWhenThrow) {
                return null;
            }
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static byte @NotNull [] download(@NotNull OkHttpClient client, @NotNull String url) {
        return OkHttpClientHelper.download((Call.Factory)client, url, "GET");
    }

    public static byte @NotNull [] download(@NotNull Call.Factory callFactory, @NotNull String url) {
        return OkHttpClientHelper.download(callFactory, url, "GET");
    }

    public static byte @NotNull [] download(@NotNull OkHttpClient client, @NotNull String url, @NotNull String method) {
        return OkHttpClientHelper.download((Call.Factory)client, url, method);
    }

    @Nullable
    public static RequestBody emptyBody(@NotNull String method) {
        return HttpMethod.requiresRequestBody((String)method) ? EMPTY : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte @NotNull [] download(@NotNull Call.Factory callFactory, @NotNull String url, @NotNull String method) {
        Request.Builder builder = new Request.Builder().url(url);
        builder.method(method, OkHttpClientHelper.emptyBody(method));
        try (Response response = OkHttpClientHelper.execute(callFactory, builder);){
            ResponseBody body = OkHttpClientHelper.extract(response);
            if (body == null) {
                byte[] byArray2 = Null.Bytes;
                return byArray2;
            }
            byte[] bytes = body.bytes();
            byte[] byArray = bytes == null ? Null.Bytes : bytes;
            return byArray;
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to download, url=" + url, e);
        }
    }

    @NotNull
    public static String getText(@NotNull OkHttpClient client, @NotNull String url) {
        return OkHttpClientHelper.getText((Call.Factory)client, url);
    }

    @NotNull
    public static String getText(@NotNull Call.Factory callFactory, @NotNull String url) {
        String string;
        block8: {
            Request.Builder builder = new Request.Builder().url(url).get();
            Response response = OkHttpClientHelper.execute(callFactory, builder);
            try {
                string = OkHttpClientHelper.extractString(response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("failed to post file, url=" + url, e);
                }
            }
            response.close();
        }
        return string;
    }

    @Contract(value="_,_,false->!null")
    public static String executeString(@NotNull OkHttpClient client, @NotNull Request request, boolean nullWhenThrow) {
        return OkHttpClientHelper.executeString((Call.Factory)client, request, nullWhenThrow);
    }

    @Contract(value="_,_,false->!null")
    public static String executeString(@NotNull Call.Factory callFactory, @NotNull Request request, boolean nullWhenThrow) {
        String string;
        block9: {
            Response response = OkHttpClientHelper.execute(callFactory, request);
            try {
                string = OkHttpClientHelper.extractString(response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (nullWhenThrow) {
                        return null;
                    }
                    throw new IORuntimeException((Throwable)e);
                }
            }
            response.close();
        }
        return string;
    }

    public static String executeJson(@NotNull OkHttpClient client, @NotNull String url, @Nullable CharSequence json, @NotNull String method) {
        return OkHttpClientHelper.executeJson((Call.Factory)client, url, json, method);
    }

    public static String executeJson(@NotNull Call.Factory callFactory, @NotNull String url, @Nullable CharSequence json, @NotNull String method) {
        String string;
        block8: {
            RequestBody body = json == null ? null : RequestBody.create((String)json.toString(), (MediaType)OkHttpMediaType.APPLICATION_JSON_VALUE);
            Request.Builder builder = new Request.Builder().url(url).method(method, body);
            Response response = OkHttpClientHelper.execute(callFactory, builder);
            try {
                string = OkHttpClientHelper.extractString(response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("failed to post file, url=" + url, e);
                }
            }
            response.close();
        }
        return string;
    }

    @NotNull
    public static Response execute(@NotNull OkHttpClient client, @NotNull Request request) throws IOException {
        return OkHttpClientHelper.execute((Call.Factory)client, request);
    }

    @NotNull
    public static Response execute(@NotNull Call.Factory callFactory, @NotNull Request request) throws IOException {
        return callFactory.newCall(request).execute();
    }

    @Contract(value="_,_,false->!null")
    public static Response execute(@NotNull OkHttpClient client, @NotNull Request request, boolean nullWhenThrow) {
        return OkHttpClientHelper.execute((Call.Factory)client, request, nullWhenThrow);
    }

    @Contract(value="_,_,false->!null")
    public static Response execute(@NotNull Call.Factory callFactory, @NotNull Request request, boolean nullWhenThrow) {
        try {
            return OkHttpClientHelper.execute(callFactory, request);
        }
        catch (IOException e) {
            if (nullWhenThrow) {
                return null;
            }
            throw new IORuntimeException((Throwable)e);
        }
    }

    @Nullable
    public static <T> T execute(@NotNull OkHttpClient client, @NotNull Request request, @NotNull BiFunction<Response, IOException, T> fun) {
        return OkHttpClientHelper.execute((Call.Factory)client, request, fun);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> T execute(@NotNull Call.Factory callFactory, @NotNull Request request, @NotNull BiFunction<Response, IOException, T> fun) {
        try (Response res = OkHttpClientHelper.execute(callFactory, request);){
            Response t = fun.apply(res, null);
            return (T)t;
        }
        catch (IOException e) {
            return (T)fun.apply(null, e);
        }
    }

    @NotNull
    public static Response execute(@NotNull OkHttpClient client, @NotNull Request.Builder builder) throws IOException {
        return OkHttpClientHelper.execute((Call.Factory)client, builder);
    }

    @NotNull
    public static Response execute(@NotNull Call.Factory callFactory, @NotNull Request.Builder builder) throws IOException {
        if (callFactory instanceof OkHttpBuildableClient) {
            return ((OkHttpBuildableClient)callFactory).newCall(builder).execute();
        }
        return callFactory.newCall(builder.build()).execute();
    }

    @Contract(value="_,_,false->!null")
    public static Response execute(@NotNull OkHttpClient client, @NotNull Request.Builder builder, boolean nullWhenThrow) {
        return OkHttpClientHelper.execute((Call.Factory)client, builder, nullWhenThrow);
    }

    @Contract(value="_,_,false->!null")
    public static Response execute(@NotNull Call.Factory callFactory, @NotNull Request.Builder builder, boolean nullWhenThrow) {
        try {
            return OkHttpClientHelper.execute(callFactory, builder);
        }
        catch (IOException e) {
            if (nullWhenThrow) {
                return null;
            }
            throw new IORuntimeException((Throwable)e);
        }
    }

    @Nullable
    public static <T> T execute(@NotNull OkHttpClient client, @NotNull Request.Builder builder, @NotNull BiFunction<Response, IOException, T> fun) {
        return OkHttpClientHelper.execute((Call.Factory)client, builder, fun);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T execute(@NotNull Call.Factory callFactory, @NotNull Request.Builder builder, @NotNull BiFunction<Response, IOException, T> fun) {
        try (Response res = OkHttpClientHelper.execute(callFactory, builder);){
            Response t = fun.apply(res, null);
            return (T)t;
        }
        catch (IOException e) {
            return (T)fun.apply(null, e);
        }
    }

    public static void clearCookie(@NotNull OkHttpClient client, @NotNull HttpUrl url) {
        CookieJar cookieJar = client.cookieJar();
        List<Cookie> list = cookieJar.loadForRequest(url).stream().map(it -> {
            Cookie.Builder builder = new Cookie.Builder().name(it.name()).path(it.path()).domain(it.domain()).value(it.value()).expiresAt(0L);
            if (it.secure()) {
                builder.secure();
            }
            if (it.httpOnly()) {
                builder.httpOnly();
            }
            return builder.build();
        }).toList();
        cookieJar.saveFromResponse(url, list);
    }

    private static final class DefaultClientHolder {
        private static final OkHttpClient DefaultClient = OkHttpClientBuilder.staticBuilder().build();

        private DefaultClientHolder() {
        }
    }
}

