/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.httprest.okhttp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.time.ThreadNow;

public class OkHttpHostCookie
implements CookieJar {
    public static final int MaxCookiePerHost = 64;
    private int maxCookiePerHost = 64;
    private final ConcurrentHashMap<String, Lk> hostCookies = new ConcurrentHashMap();

    public int getMaxCookiePerHost() {
        return this.maxCookiePerHost;
    }

    public void setMaxCookiePerHost(int max) {
        this.maxCookiePerHost = Math.max(64, max);
    }

    public void saveFromResponse(HttpUrl url, @NotNull List<Cookie> cks) {
        this.hostCookies.computeIfAbsent(url.host(), k -> new Lk(this.maxCookiePerHost)).save(cks);
    }

    @NotNull
    public List<Cookie> loadForRequest(HttpUrl url) {
        Lk cookies = this.hostCookies.get(url.host());
        return cookies != null ? cookies.load(url) : Collections.emptyList();
    }

    private static class Lk {
        private final int maxCookies;
        private final LinkedHashMap<Ck, Cookie> cookies = new LinkedHashMap();
        private final ReadWriteLock rwLock = new ReentrantReadWriteLock();

        public Lk(int max) {
            this.maxCookies = max;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save(@NotNull List<Cookie> cks) {
            Lock lk = this.rwLock.writeLock();
            lk.lock();
            try {
                long now = ThreadNow.millis();
                if (this.cookies.size() >= this.maxCookies) {
                    this.cookies.entrySet().removeIf(it -> ((Cookie)it.getValue()).expiresAt() < now);
                }
                for (Cookie ck : cks) {
                    Ck k = new Ck(ck);
                    if (ck.expiresAt() > now) {
                        this.cookies.put(k, ck);
                        continue;
                    }
                    this.cookies.remove(k);
                }
            }
            finally {
                lk.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public List<Cookie> load(HttpUrl url) {
            Lock lk = this.rwLock.readLock();
            lk.lock();
            try {
                int size = this.cookies.size();
                if (size == 0) {
                    List<Cookie> list = Collections.emptyList();
                    return list;
                }
                ArrayList<Cookie> rst = new ArrayList<Cookie>(size);
                for (Cookie ck : this.cookies.values()) {
                    if (!ck.matches(url)) continue;
                    rst.add(ck);
                }
                ArrayList<Cookie> arrayList = rst;
                return arrayList;
            }
            finally {
                lk.unlock();
            }
        }
    }

    private static class Ck {
        private final String host;
        private final String path;
        private final String name;
        private final boolean secure;
        private final int hash;

        public Ck(Cookie ck) {
            this.host = ck.domain();
            this.path = ck.path();
            this.name = ck.name();
            this.secure = ck.secure();
            int h = this.secure ? 1 : 0;
            h = 31 * h + this.host.hashCode();
            h = 31 * h + this.path.hashCode();
            this.hash = h = 31 * h + this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Ck)) {
                return false;
            }
            Ck ck = (Ck)o;
            return this.secure == ck.secure && Objects.equals(this.host, ck.host) && Objects.equals(this.path, ck.path) && Objects.equals(this.name, ck.name);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

