/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.httprest.okhttp;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.logging.LogLevel;
import pro.fessional.mirana.time.StopWatch;
import pro.fessional.wings.silencer.tweak.TweakLogger;
import pro.fessional.wings.silencer.watch.Watches;
import pro.fessional.wings.slardar.httprest.okhttp.OkHttpInterceptor;

public class OkHttpTweakLogInterceptor
implements OkHttpInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OkHttpTweakLogInterceptor.class);
    public static final HttpLoggingInterceptor.Logger LoggerTrace = arg_0 -> ((Logger)log).trace(arg_0);
    public static final HttpLoggingInterceptor.Logger LoggerDebug = arg_0 -> ((Logger)log).debug(arg_0);
    public static final HttpLoggingInterceptor.Logger LoggerInfo = arg_0 -> ((Logger)log).info(arg_0);
    public static final HttpLoggingInterceptor.Logger LoggerWarn = arg_0 -> ((Logger)log).warn(arg_0);
    private final EnumMap<LogLevel, HttpLoggingInterceptor> mapping = new EnumMap(LogLevel.class);
    private final Set<String> nopUrlToken = new HashSet<String>();

    public OkHttpTweakLogInterceptor(Collection<String> nop) {
        this.resetMapping();
        TweakLogger.asCoreLevel((String)log.getName());
        this.nopUrlToken.addAll(nop);
    }

    public void levelMapping(@NotNull LogLevel lg, @NotNull HttpLoggingInterceptor.Level ok) {
        HttpLoggingInterceptor.Logger okl = lg == LogLevel.TRACE || lg == LogLevel.DEBUG ? LoggerDebug : (lg == LogLevel.INFO ? LoggerInfo : LoggerWarn);
        HttpLoggingInterceptor itc = new HttpLoggingInterceptor(okl);
        itc.setLevel(ok);
        this.mapping.put(lg, itc);
    }

    public void resetMapping() {
        HttpLoggingInterceptor none = new HttpLoggingInterceptor(LoggerWarn);
        none.setLevel(HttpLoggingInterceptor.Level.NONE);
        HttpLoggingInterceptor basic = new HttpLoggingInterceptor(LoggerInfo);
        basic.setLevel(HttpLoggingInterceptor.Level.BASIC);
        HttpLoggingInterceptor body = new HttpLoggingInterceptor(LoggerDebug);
        body.setLevel(HttpLoggingInterceptor.Level.BODY);
        this.mapping.put(LogLevel.OFF, none);
        this.mapping.put(LogLevel.FATAL, none);
        this.mapping.put(LogLevel.ERROR, none);
        this.mapping.put(LogLevel.WARN, none);
        this.mapping.put(LogLevel.INFO, basic);
        this.mapping.put(LogLevel.DEBUG, body);
        this.mapping.put(LogLevel.TRACE, body);
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        boolean off = false;
        if (!this.nopUrlToken.isEmpty()) {
            String url = chain.request().url().toString();
            for (String tkn : this.nopUrlToken) {
                if (!StringUtils.containsIgnoreCase((CharSequence)url, (CharSequence)tkn)) continue;
                log.debug("exclude intercept, token={}, url={}", (Object)tkn, (Object)url);
                off = true;
                break;
            }
        }
        LogLevel lvl = off ? LogLevel.OFF : TweakLogger.currentLevel((String)log.getName());
        HttpLoggingInterceptor itc = this.mapping.get(lvl);
        StopWatch current = Watches.current();
        if (current == null) {
            return itc.intercept(chain);
        }
        Request request = chain.request();
        String name = "OkHttp " + request.method() + " " + String.valueOf(request.url());
        try {
            Response response;
            block12: {
                StopWatch.Watch ignore = current.start(name);
                try {
                    response = itc.intercept(chain);
                    if (ignore == null) break block12;
                }
                catch (Throwable throwable) {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignore.close();
            }
            return response;
        }
        finally {
            Watches.release((boolean)true);
        }
    }

    @Override
    public boolean isNetwork() {
        return true;
    }
}

