/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.io.IOException;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import pro.fessional.mirana.bits.Aes;
import pro.fessional.mirana.bits.Aes256;
import pro.fessional.wings.silencer.encrypt.Aes256Provider;
import pro.fessional.wings.slardar.jackson.AesString;

public class AesStringDeserializer
extends JsonDeserializer<String>
implements ContextualDeserializer {
    private Aes aes;
    @NotNull
    private String mis = "*****";

    public String deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        String value = parser.getValueAsString();
        return this.aes == null ? this.mis : this.aes.decode64(value);
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        AesString anno = (AesString)property.getAnnotation(AesString.class);
        if (anno == null) {
            return this;
        }
        AesString.Misfire mf = anno.misfire();
        Aes256 aes256 = Aes256Provider.get((String)anno.value(), (boolean)false);
        if (aes256 == null && mf == AesString.Misfire.Error) {
            throw new IllegalArgumentException("Aes key not found, name=" + anno.value());
        }
        AesStringDeserializer ser = new AesStringDeserializer();
        ser.aes = aes256;
        if (mf == AesString.Misfire.Masks) {
            ser.mis = "*****";
        } else if (mf == AesString.Misfire.Empty) {
            ser.mis = "";
        }
        return ser;
    }

    @Autowired
    @Generated
    public void setAes(Aes aes) {
        this.aes = aes;
    }
}

