/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.TypeDescriptor;
import pro.fessional.mirana.text.WhiteUtil;
import pro.fessional.mirana.time.DateFormatter;
import pro.fessional.wings.silencer.datetime.DateTimePattern;
import pro.fessional.wings.silencer.support.TypeSugar;
import pro.fessional.wings.slardar.autozone.AutoZoneType;
import pro.fessional.wings.slardar.autozone.json.JacksonLocalDateTimeDeserializer;
import pro.fessional.wings.slardar.autozone.json.JacksonLocalDateTimeSerializer;
import pro.fessional.wings.slardar.autozone.json.JacksonOffsetDateTimeDeserializer;
import pro.fessional.wings.slardar.autozone.json.JacksonOffsetDateTimeSerializer;
import pro.fessional.wings.slardar.autozone.json.JacksonZonedDateTimeDeserializer;
import pro.fessional.wings.slardar.autozone.json.JacksonZonedDateTimeSerializer;

public class JacksonHelper {
    public static final DeserializationFeature[] EnableDeserializationFeature = new DeserializationFeature[]{DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES, DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE};
    public static final JsonGenerator.Feature[] EnableJsonGeneratorFeature = new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN};
    public static final MapperFeature[] EnableMapperFeature = new MapperFeature[]{MapperFeature.PROPAGATE_TRANSIENT_MARKER, MapperFeature.DEFAULT_VIEW_INCLUSION, MapperFeature.ALLOW_EXPLICIT_PROPERTY_RENAMING};
    public static final JsonParser.Feature[] EnableParserFeature = new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS, JsonParser.Feature.ALLOW_YAML_COMMENTS, JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, JsonParser.Feature.ALLOW_SINGLE_QUOTES, JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, JsonParser.Feature.ALLOW_MISSING_VALUES, JsonParser.Feature.ALLOW_TRAILING_COMMA};
    public static final SerializationFeature[] EnableSerializationFeature = new SerializationFeature[]{SerializationFeature.CLOSE_CLOSEABLE};
    public static final JsonParser.Feature[] DisableParserFeature = new JsonParser.Feature[]{JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER};
    public static final DeserializationFeature[] DisableDeserializationFeature = new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES};
    public static final SerializationFeature[] DisableSerializationFeature = new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, SerializationFeature.FAIL_ON_EMPTY_BEANS};
    public static final JacksonLocalDateTimeDeserializer PlainLocalDateTimeDeserializer = new JacksonLocalDateTimeDeserializer(DateTimeFormatter.ISO_LOCAL_DATE_TIME, List.of(DateFormatter.FMT_FULL_PSE), AutoZoneType.Off);
    public static final JacksonOffsetDateTimeDeserializer PlainOffsetDateTimeDeserializer = new JacksonOffsetDateTimeDeserializer(DateTimeFormatter.ISO_OFFSET_DATE_TIME, List.of(DateFormatter.FMT_ZONE_PSE), AutoZoneType.Off);
    public static final JacksonZonedDateTimeSerializer PlainZonedDateTimeSerializer = new JacksonZonedDateTimeSerializer(DateTimePattern.FMT_FULL_19TV, AutoZoneType.Off);
    public static final JacksonZonedDateTimeDeserializer PlainZonedDateTimeDeserializer = new JacksonZonedDateTimeDeserializer(DateTimePattern.FMT_FULL_19TV, List.of(DateFormatter.FMT_ZONE_PSE), AutoZoneType.Off);
    public static final SimpleModule PlainDateTimeModule = new SimpleModule(){
        {
            this.addDeserializer(LocalDateTime.class, (JsonDeserializer)PlainLocalDateTimeDeserializer);
            this.addDeserializer(OffsetDateTime.class, (JsonDeserializer)PlainOffsetDateTimeDeserializer);
            this.addSerializer(ZonedDateTime.class, (JsonSerializer)PlainZonedDateTimeSerializer);
            this.addDeserializer(ZonedDateTime.class, (JsonDeserializer)PlainZonedDateTimeDeserializer);
        }
    };
    public static final ObjectMapper JsonPlain = JacksonHelper.buildPlain((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    public static final XmlMapper XmlPlain = (XmlMapper)JacksonHelper.buildPlain((XmlMapper.Builder)XmlMapper.builder().findAndAddModules()).build();
    public static final TypeFactory TypeFactoryPlain = JsonPlain.getTypeFactory();
    protected static JacksonLocalDateTimeSerializer beanLocalDateTimeSerializer;
    protected static JacksonLocalDateTimeDeserializer beanLocalDateTimeDeserializer;
    protected static JacksonZonedDateTimeSerializer beanZonedDateTimeSerializer;
    protected static JacksonZonedDateTimeDeserializer beanZonedDateTimeDeserializer;
    protected static JacksonOffsetDateTimeSerializer beanOffsetDateTimeSerializer;
    protected static JacksonOffsetDateTimeDeserializer beanOffsetDateTimeDeserializer;
    private static ObjectMapper JsonWings;
    private static XmlMapper XmlWings;
    private static boolean wingsPrepared;
    private static ObjectMapper JsonBean;
    private static XmlMapper XmlBean;
    private static boolean beanPrepared;

    @Contract(value="_->param1")
    public static <T extends MapperBuilder<?, ?>> T buildPlain(@NotNull T builder) {
        builder.enable(EnableDeserializationFeature).enable(EnableJsonGeneratorFeature).enable(EnableMapperFeature).enable(EnableParserFeature).enable(EnableSerializationFeature).disable(DisableParserFeature).disable(DisableDeserializationFeature).disable(DisableSerializationFeature).addModule((Module)PlainDateTimeModule);
        return builder;
    }

    @Contract(value="_->param1")
    public static <T extends ObjectMapper> T buildWings(@NotNull T mapper) {
        SimpleModule beanDateTimeModule = new SimpleModule();
        boolean hasBean = false;
        if (beanLocalDateTimeSerializer != null) {
            hasBean = true;
            beanDateTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)beanLocalDateTimeSerializer.autoOff());
        }
        if (beanLocalDateTimeDeserializer != null) {
            hasBean = true;
            beanDateTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)beanLocalDateTimeDeserializer.autoOff());
        }
        if (beanZonedDateTimeSerializer != null) {
            hasBean = true;
            beanDateTimeModule.addSerializer(ZonedDateTime.class, (JsonSerializer)beanZonedDateTimeSerializer.autoOff());
        }
        if (beanZonedDateTimeDeserializer != null) {
            hasBean = true;
            beanDateTimeModule.addDeserializer(ZonedDateTime.class, (JsonDeserializer)beanZonedDateTimeDeserializer.autoOff());
        }
        if (beanOffsetDateTimeSerializer != null) {
            hasBean = true;
            beanDateTimeModule.addSerializer(OffsetDateTime.class, (JsonSerializer)beanOffsetDateTimeSerializer.autoOff());
        }
        if (beanOffsetDateTimeDeserializer != null) {
            hasBean = true;
            beanDateTimeModule.addDeserializer(OffsetDateTime.class, (JsonDeserializer)beanOffsetDateTimeDeserializer.autoOff());
        }
        SimpleModule dtm = hasBean ? beanDateTimeModule : PlainDateTimeModule;
        mapper.registerModule((Module)dtm);
        return mapper;
    }

    protected static void prepareWings(@NotNull ObjectMapper json, @NotNull XmlMapper xml) {
        JsonWings = JacksonHelper.buildWings(json);
        XmlWings = JacksonHelper.buildWings(xml);
        wingsPrepared = true;
    }

    protected static void prepareBean(@NotNull ObjectMapper json, @NotNull XmlMapper xml) {
        JsonBean = json;
        XmlBean = xml;
        beanPrepared = true;
    }

    public static boolean isPrepared(@NotNull Style style) {
        return switch (style.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> true;
            case 2 -> wingsPrepared;
            case 0 -> beanPrepared;
        };
    }

    @NotNull
    public static ObjectMapper JsonBean() {
        if (JsonBean == null) {
            throw new IllegalStateException("JsonBean not init, check SlardarJacksonWebConfiguration.jacksonHelperRunner");
        }
        return JsonBean;
    }

    @NotNull
    public static XmlMapper XmlBean() {
        if (XmlBean == null) {
            throw new IllegalStateException("XmlBean not init, check SlardarJacksonWebConfiguration.jacksonHelperRunner");
        }
        return XmlBean;
    }

    @NotNull
    public static ObjectMapper MapperBean(boolean json) {
        return json ? JacksonHelper.JsonBean() : JacksonHelper.XmlBean();
    }

    @NotNull
    public static ObjectMapper JsonPlain() {
        return JsonPlain;
    }

    @NotNull
    public static XmlMapper XmlPlain() {
        return XmlPlain;
    }

    @NotNull
    public static ObjectMapper MapperPlain(boolean json) {
        return json ? JsonPlain : XmlPlain;
    }

    @NotNull
    public static ObjectMapper JsonWings() {
        return JsonWings;
    }

    @NotNull
    public static XmlMapper XmlWings() {
        return XmlWings;
    }

    @NotNull
    public static ObjectMapper MapperWings(boolean json) {
        return json ? JsonWings : XmlWings;
    }

    @NotNull
    public static ObjectMapper Mapper(@NotNull Style style, boolean json) {
        return switch (style.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> JacksonHelper.MapperWings(json);
            case 1 -> JacksonHelper.MapperPlain(json);
            case 0 -> JacksonHelper.MapperBean(json);
        };
    }

    @Contract(value="null->false")
    public static boolean asXml(String str) {
        if (str == null) {
            return false;
        }
        char c1 = WhiteUtil.firstNonWhite((CharSequence)str);
        if (c1 == '<') {
            char c2 = WhiteUtil.lastNonWhite((CharSequence)str);
            return c2 == '>';
        }
        return false;
    }

    @Contract(value="null->false")
    public static boolean asXml(byte[] str) {
        if (str == null) {
            return false;
        }
        byte c1 = WhiteUtil.firstNonWhite((byte[])str);
        if (c1 == 60) {
            byte c2 = WhiteUtil.lastNonWhite((byte[])str);
            return c2 == 62;
        }
        return false;
    }

    public static JavaType javaType(@NotNull Class<?> targetType, Class<?> ... generics) {
        Type type = TypeSugar.type(targetType, (Class[])generics);
        return TypeFactoryPlain.constructType(type);
    }

    public static JavaType javaType(@NotNull TypeDescriptor targetType) {
        Type type = targetType.getResolvableType().getType();
        return TypeFactoryPlain.constructType(type);
    }

    public static JavaType javaType(@NotNull ResolvableType targetType) {
        return TypeFactoryPlain.constructType(targetType.getType());
    }

    @Contract(value="!null,_,_->!null")
    public static <T> T object(String text, @NotNull Class<?> targetType, Class<?> ... generics) {
        if (text == null) {
            return null;
        }
        return (T)JacksonHelper.MapperWings(!JacksonHelper.asXml(text)).readValue(text, JacksonHelper.javaType(targetType, generics));
    }

    @Contract(value="_,!null,_,_ -> !null")
    public static <T> T object(@NotNull Style style, String text, @NotNull Class<?> targetType, Class<?> ... generics) {
        if (text == null) {
            return null;
        }
        return (T)JacksonHelper.Mapper(style, !JacksonHelper.asXml(text)).readValue(text, JacksonHelper.javaType(targetType, generics));
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(String text, @NotNull JavaType targetType) {
        if (text == null) {
            return null;
        }
        return (T)JacksonHelper.MapperWings(!JacksonHelper.asXml(text)).readValue(text, targetType);
    }

    @Contract(value="_,!null,_ -> !null")
    public static <T> T object(@NotNull Style style, String text, @NotNull JavaType targetType) {
        if (text == null) {
            return null;
        }
        return (T)JacksonHelper.Mapper(style, !JacksonHelper.asXml(text)).readValue(text, targetType);
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(String text, @NotNull ResolvableType targetType) {
        if (text == null) {
            return null;
        }
        return (T)JacksonHelper.MapperWings(!JacksonHelper.asXml(text)).readValue(text, JacksonHelper.javaType(targetType));
    }

    @Contract(value="_,!null,_ -> !null")
    public static <T> T object(@NotNull Style style, String text, @NotNull ResolvableType targetType) {
        if (text == null) {
            return null;
        }
        return (T)JacksonHelper.Mapper(style, !JacksonHelper.asXml(text)).readValue(text, JacksonHelper.javaType(targetType));
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(String text, @NotNull TypeDescriptor targetType) {
        if (text == null) {
            return null;
        }
        return (T)JacksonHelper.MapperWings(!JacksonHelper.asXml(text)).readValue(text, JacksonHelper.javaType(targetType));
    }

    @Contract(value="_,!null,_ -> !null")
    public static <T> T object(@NotNull Style style, String text, @NotNull TypeDescriptor targetType) {
        if (text == null) {
            return null;
        }
        return (T)JacksonHelper.Mapper(style, !JacksonHelper.asXml(text)).readValue(text, JacksonHelper.javaType(targetType));
    }

    @Contract(value="!null->!null")
    public static JsonNode object(String text) {
        if (text == null) {
            return null;
        }
        return JacksonHelper.MapperWings(!JacksonHelper.asXml(text)).readTree(text);
    }

    @Contract(value="!null,_,_->!null")
    public static <T> T object(byte[] text, @NotNull Class<?> targetType, Class<?> ... generics) {
        if (text == null) {
            return null;
        }
        return (T)JacksonHelper.MapperWings(!JacksonHelper.asXml(text)).readValue(text, JacksonHelper.javaType(targetType, generics));
    }

    @Contract(value="_,!null,_,_ -> !null")
    public static <T> T object(@NotNull Style style, byte[] text, @NotNull Class<?> targetType, Class<?> ... generics) {
        if (text == null) {
            return null;
        }
        return (T)JacksonHelper.Mapper(style, !JacksonHelper.asXml(text)).readValue(text, JacksonHelper.javaType(targetType, generics));
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(byte[] text, @NotNull JavaType targetType) {
        if (text == null) {
            return null;
        }
        return (T)JacksonHelper.MapperWings(!JacksonHelper.asXml(text)).readValue(text, targetType);
    }

    @Contract(value="_, !null, _ -> !null")
    public static <T> T object(@NotNull Style style, byte[] text, @NotNull JavaType targetType) {
        if (text == null) {
            return null;
        }
        return (T)JacksonHelper.Mapper(style, !JacksonHelper.asXml(text)).readValue(text, targetType);
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(byte[] text, @NotNull ResolvableType targetType) {
        if (text == null) {
            return null;
        }
        return (T)JacksonHelper.MapperWings(!JacksonHelper.asXml(text)).readValue(text, JacksonHelper.javaType(targetType));
    }

    @Contract(value="_, !null, _ -> !null")
    public static <T> T object(@NotNull Style style, byte[] text, @NotNull ResolvableType targetType) {
        if (text == null) {
            return null;
        }
        return (T)JacksonHelper.Mapper(style, !JacksonHelper.asXml(text)).readValue(text, JacksonHelper.javaType(targetType));
    }

    @Contract(value="!null,_->!null")
    public static <T> T object(byte[] text, @NotNull TypeDescriptor targetType) {
        if (text == null) {
            return null;
        }
        return (T)JacksonHelper.MapperWings(!JacksonHelper.asXml(text)).readValue(text, JacksonHelper.javaType(targetType));
    }

    @Contract(value="_, !null, _ -> !null")
    public static <T> T object(@NotNull Style style, byte[] text, @NotNull TypeDescriptor targetType) {
        if (text == null) {
            return null;
        }
        return (T)JacksonHelper.Mapper(style, !JacksonHelper.asXml(text)).readValue(text, JacksonHelper.javaType(targetType));
    }

    @Contract(value="!null->!null")
    public static JsonNode object(byte[] text) {
        if (text == null) {
            return null;
        }
        return JacksonHelper.MapperWings(!JacksonHelper.asXml(text)).readTree(text);
    }

    @Contract(value="_, !null -> !null")
    public static JsonNode object(@NotNull Style style, byte[] text) {
        if (text == null) {
            return null;
        }
        return JacksonHelper.Mapper(style, !JacksonHelper.asXml(text)).readTree(text);
    }

    @Contract(value="!null->!null")
    public static String string(Object obj) {
        return obj == null ? null : JacksonHelper.MapperWings(true).writeValueAsString(obj);
    }

    @Contract(value="_, !null -> !null")
    public static String string(@NotNull Style style, Object obj) {
        return obj == null ? null : JacksonHelper.Mapper(style, true).writeValueAsString(obj);
    }

    @Contract(value="!null,_->!null")
    public static String string(Object obj, boolean json) {
        return obj == null ? null : JacksonHelper.MapperWings(json).writeValueAsString(obj);
    }

    @Contract(value="_, !null, _ -> !null")
    public static String string(@NotNull Style style, Object obj, boolean json) {
        return obj == null ? null : JacksonHelper.Mapper(style, json).writeValueAsString(obj);
    }

    @Contract(value="!null->!null")
    public static byte[] bytes(Object obj) {
        return obj == null ? null : JacksonHelper.MapperWings(true).writeValueAsBytes(obj);
    }

    @Contract(value="_, !null -> !null")
    public static byte[] bytes(@NotNull Style style, Object obj) {
        return obj == null ? null : JacksonHelper.Mapper(style, true).writeValueAsBytes(obj);
    }

    @Contract(value="!null,_->!null")
    public static byte[] bytes(Object obj, boolean json) {
        return obj == null ? null : JacksonHelper.MapperWings(json).writeValueAsBytes(obj);
    }

    @Contract(value="_, !null, _ -> !null")
    public static byte[] bytes(@NotNull Style style, Object obj, boolean json) {
        return obj == null ? null : JacksonHelper.Mapper(style, json).writeValueAsBytes(obj);
    }

    @Contract(value="_,_,!null->!null")
    public static String getString(JsonNode node, String field, String defaults) {
        if (node == null) {
            return defaults;
        }
        JsonNode jn = node.get(field);
        return jn != null ? jn.asText(defaults) : defaults;
    }

    public static boolean getBoolean(JsonNode node, String field, boolean defaults) {
        if (node == null) {
            return defaults;
        }
        JsonNode jn = node.get(field);
        return jn != null ? jn.asBoolean(defaults) : defaults;
    }

    public static int getInt(JsonNode node, String field, int defaults) {
        if (node == null) {
            return defaults;
        }
        JsonNode jn = node.get(field);
        return jn != null ? jn.asInt(defaults) : defaults;
    }

    public static long getLong(JsonNode node, String field, long defaults) {
        if (node == null) {
            return defaults;
        }
        JsonNode jn = node.get(field);
        return jn != null ? jn.asLong(defaults) : defaults;
    }

    public static double getDouble(JsonNode node, String field, double defaults) {
        if (node == null) {
            return defaults;
        }
        JsonNode jn = node.get(field);
        return jn != null ? jn.asDouble(defaults) : defaults;
    }

    static {
        JsonWings = JsonPlain;
        XmlWings = XmlPlain;
        wingsPrepared = false;
        JsonBean = null;
        XmlBean = null;
        beanPrepared = false;
    }

    public static enum Style {
        Bean,
        Plain,
        Wings;

    }
}

