/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.monitor.metric;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.unit.DataSize;
import pro.fessional.mirana.stat.LogStat;
import pro.fessional.wings.slardar.monitor.WarnMetric;

public class LogMetric
implements WarnMetric {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogMetric.class);
    private final String key;
    private final Rule rule;
    private final AtomicReference<LogStat.Stat> cache = new AtomicReference();
    private final String keyMinGrow;
    private final String keyMaxGrow;
    private final String keyMaxSize;
    private final String keyKeyword;
    private volatile long lastClean = 0L;

    public LogMetric(String key, Rule rule) {
        this.key = key;
        this.rule = rule;
        this.keyMinGrow = "wings.slardar.monitor.log.min-grow".substring("wings.slardar.monitor.log".length() + 1);
        this.keyMaxGrow = "wings.slardar.monitor.log.max-grow".substring("wings.slardar.monitor.log".length() + 1);
        this.keyMaxSize = "wings.slardar.monitor.log.max-size".substring("wings.slardar.monitor.log".length() + 1);
        this.keyKeyword = "wings.slardar.monitor.log.keyword".substring("wings.slardar.monitor.log".length() + 1);
    }

    public Rule getRule() {
        return this.rule;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public List<WarnMetric.Warn> check() {
        String file = this.rule.getFile();
        if (file == null || file.isEmpty() || !this.rule.isEnable()) {
            log.debug("skip un-conf file or disable");
            return Collections.emptyList();
        }
        long from = this.readLastForm();
        LogStat.Stat stat = LogStat.stat((String)this.rule.file, (long)from, (int)this.rule.getPreview(), (int)this.rule.getSection(), this.rule.genStatKey());
        log.debug("LogStat-{}, stat={}", (Object)this.key, (Object)stat);
        this.writeLastFrom(stat);
        if (stat.getTimeDone() - this.lastClean > 86400000L) {
            List cln = LogStat.clean((String)file, (int)this.rule.clean);
            log.info("LogStat clean {} days scanned file count={}", (Object)this.rule.clean, (Object)cln.size());
            this.lastClean = stat.getTimeDone();
        }
        ArrayList<WarnMetric.Warn> result = new ArrayList<WarnMetric.Warn>();
        long byteGrow = stat.getByteGrow();
        this.check(result, this.keyMinGrow, this.rule.minGrow, byteGrow, true);
        this.check(result, this.keyMaxGrow, this.rule.maxGrow, byteGrow, false);
        this.check(result, this.keyMaxSize, this.rule.maxSize, stat.getByteDone(), false);
        if (stat.getPathOut() != null) {
            WarnMetric.Warn warn = new WarnMetric.Warn();
            warn.setKey(this.keyKeyword);
            warn.setType(WarnMetric.Type.File);
            warn.setRule(this.maskKeyword());
            warn.setWarn(stat.getPathOut());
            result.add(warn);
        }
        return result;
    }

    private void writeLastFrom(LogStat.Stat stat) {
        this.cache.set(stat);
        File tmp = this.getLastStatFile();
        try {
            FileUtils.write((File)tmp, (CharSequence)String.valueOf(stat.getByteDone()), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private long readLastForm() {
        LogStat.Stat last = this.cache.get();
        if (last == null) {
            File tmp = this.getLastStatFile();
            if (tmp.canRead() && tmp.length() > 0L) {
                try {
                    return Long.parseLong(FileUtils.readFileToString((File)tmp, (Charset)StandardCharsets.UTF_8));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return 0L;
        }
        return last.getByteDone();
    }

    private File getLastStatFile() {
        return new File(this.rule.getFile() + ".log-metric.tmp");
    }

    private String maskKeyword() {
        StringBuilder sb = new StringBuilder();
        for (String k : this.rule.level) {
            sb.append(",");
            sb.append(this.rule.maskKey(k));
        }
        for (String k : this.rule.keyword) {
            sb.append(",");
            sb.append(this.rule.maskKey(k));
        }
        return sb.isEmpty() ? "" : sb.substring(1);
    }

    private void check(List<WarnMetric.Warn> result, String key, DataSize ruleValue, long warnValue, boolean less) {
        long value = ruleValue.toBytes();
        if (value < 0L) {
            return;
        }
        if (less && warnValue < value || !less && warnValue > value) {
            WarnMetric.Warn warn = new WarnMetric.Warn();
            warn.setKey(key);
            warn.setType(WarnMetric.Type.Text);
            warn.setRule(String.format("%,dKB", ruleValue.toKilobytes()));
            warn.setWarn(String.format("%,dKB", warnValue / 1024L));
            result.add(warn);
        }
    }

    public static class Rule {
        public static final String Key = "wings.slardar.monitor.log";
        private boolean enable = true;
        public static final String Key$enable = "wings.slardar.monitor.log.enable";
        private String file;
        public static final String Key$file = "wings.slardar.monitor.log.file";
        private DataSize minGrow = null;
        public static final String Key$minGrow = "wings.slardar.monitor.log.min-grow";
        private DataSize maxGrow = null;
        public static final String Key$maxGrow = "wings.slardar.monitor.log.max-grow";
        private DataSize maxSize = null;
        public static final String Key$maxSize = "wings.slardar.monitor.log.max-size";
        private int bound = 40;
        public static final String Key$bound = "wings.slardar.monitor.log.bound";
        private Set<String> level = Collections.emptySet();
        public static final String Key$level = "wings.slardar.monitor.log.level";
        private Set<String> keyword = Collections.emptySet();
        public static final String Key$keyword = "wings.slardar.monitor.log.keyword";
        private int preview = 10;
        public static final String Key$preview = "wings.slardar.monitor.log.preview";
        private int section = 50;
        public static final String Key$section = "wings.slardar.monitor.log.section";
        private String charset = "UTF8";
        public static final String Key$charset = "wings.slardar.monitor.log.charset";
        private int clean = 30;
        public static final String Key$clean = "wings.slardar.monitor.log.clean";

        public String trimKey(String kw, boolean white) {
            int kl = kw.length();
            if (kl >= 2) {
                int il = kl - 1;
                if (kw.charAt(0) == '\'' && kw.charAt(il) == '\'') {
                    kw = kw.substring(1, il);
                    log.trace("trim quoted doubl-quote={} to key={}", (Object)kw, (Object)kw);
                }
            }
            if (white) {
                kw = kw.trim();
            }
            if (kw.isEmpty()) {
                throw new IllegalArgumentException("do NOT support empty keyword");
            }
            return kw;
        }

        public String maskKey(String kw) {
            String s = this.trimKey(kw, true);
            return (s.length() < 3 ? s : s.substring(0, 3)) + "...";
        }

        public List<LogStat.Word> genStatKey() {
            ArrayList<LogStat.Word> rst = new ArrayList<LogStat.Word>();
            for (String kw : this.genRuleKey()) {
                LogStat.Word wd = new LogStat.Word();
                wd.range2 = this.bound;
                wd.bytes = kw.getBytes(this.charset);
                rst.add(wd);
            }
            return rst;
        }

        public List<String> genRuleKey() {
            String kw;
            ArrayList<String> rst = new ArrayList<String>();
            if (this.level == null) {
                return rst;
            }
            for (String s : this.level) {
                kw = this.trimKey(s, false);
                if (kw.isEmpty()) continue;
                rst.add(kw);
            }
            for (String s : this.keyword) {
                kw = this.trimKey(s, false);
                if (!kw.isEmpty()) continue;
                rst.add(kw);
            }
            return rst;
        }

        @Generated
        public Rule() {
        }

        @Generated
        public boolean isEnable() {
            return this.enable;
        }

        @Generated
        public String getFile() {
            return this.file;
        }

        @Generated
        public DataSize getMinGrow() {
            return this.minGrow;
        }

        @Generated
        public DataSize getMaxGrow() {
            return this.maxGrow;
        }

        @Generated
        public DataSize getMaxSize() {
            return this.maxSize;
        }

        @Generated
        public int getBound() {
            return this.bound;
        }

        @Generated
        public Set<String> getLevel() {
            return this.level;
        }

        @Generated
        public Set<String> getKeyword() {
            return this.keyword;
        }

        @Generated
        public int getPreview() {
            return this.preview;
        }

        @Generated
        public int getSection() {
            return this.section;
        }

        @Generated
        public String getCharset() {
            return this.charset;
        }

        @Generated
        public int getClean() {
            return this.clean;
        }

        @Generated
        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        @Generated
        public void setFile(String file) {
            this.file = file;
        }

        @Generated
        public void setMinGrow(DataSize minGrow) {
            this.minGrow = minGrow;
        }

        @Generated
        public void setMaxGrow(DataSize maxGrow) {
            this.maxGrow = maxGrow;
        }

        @Generated
        public void setMaxSize(DataSize maxSize) {
            this.maxSize = maxSize;
        }

        @Generated
        public void setBound(int bound) {
            this.bound = bound;
        }

        @Generated
        public void setLevel(Set<String> level) {
            this.level = level;
        }

        @Generated
        public void setKeyword(Set<String> keyword) {
            this.keyword = keyword;
        }

        @Generated
        public void setPreview(int preview) {
            this.preview = preview;
        }

        @Generated
        public void setSection(int section) {
            this.section = section;
        }

        @Generated
        public void setCharset(String charset) {
            this.charset = charset;
        }

        @Generated
        public void setClean(int clean) {
            this.clean = clean;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Rule)) {
                return false;
            }
            Rule other = (Rule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnable() != other.isEnable()) {
                return false;
            }
            if (this.getBound() != other.getBound()) {
                return false;
            }
            if (this.getPreview() != other.getPreview()) {
                return false;
            }
            if (this.getSection() != other.getSection()) {
                return false;
            }
            if (this.getClean() != other.getClean()) {
                return false;
            }
            String this$file = this.getFile();
            String other$file = other.getFile();
            if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
                return false;
            }
            DataSize this$minGrow = this.getMinGrow();
            DataSize other$minGrow = other.getMinGrow();
            if (this$minGrow == null ? other$minGrow != null : !this$minGrow.equals(other$minGrow)) {
                return false;
            }
            DataSize this$maxGrow = this.getMaxGrow();
            DataSize other$maxGrow = other.getMaxGrow();
            if (this$maxGrow == null ? other$maxGrow != null : !this$maxGrow.equals(other$maxGrow)) {
                return false;
            }
            DataSize this$maxSize = this.getMaxSize();
            DataSize other$maxSize = other.getMaxSize();
            if (this$maxSize == null ? other$maxSize != null : !this$maxSize.equals(other$maxSize)) {
                return false;
            }
            Set<String> this$level = this.getLevel();
            Set<String> other$level = other.getLevel();
            if (this$level == null ? other$level != null : !((Object)this$level).equals(other$level)) {
                return false;
            }
            Set<String> this$keyword = this.getKeyword();
            Set<String> other$keyword = other.getKeyword();
            if (this$keyword == null ? other$keyword != null : !((Object)this$keyword).equals(other$keyword)) {
                return false;
            }
            String this$charset = this.getCharset();
            String other$charset = other.getCharset();
            return !(this$charset == null ? other$charset != null : !this$charset.equals(other$charset));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Rule;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnable() ? 79 : 97);
            result = result * 59 + this.getBound();
            result = result * 59 + this.getPreview();
            result = result * 59 + this.getSection();
            result = result * 59 + this.getClean();
            String $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : $file.hashCode());
            DataSize $minGrow = this.getMinGrow();
            result = result * 59 + ($minGrow == null ? 43 : $minGrow.hashCode());
            DataSize $maxGrow = this.getMaxGrow();
            result = result * 59 + ($maxGrow == null ? 43 : $maxGrow.hashCode());
            DataSize $maxSize = this.getMaxSize();
            result = result * 59 + ($maxSize == null ? 43 : $maxSize.hashCode());
            Set<String> $level = this.getLevel();
            result = result * 59 + ($level == null ? 43 : ((Object)$level).hashCode());
            Set<String> $keyword = this.getKeyword();
            result = result * 59 + ($keyword == null ? 43 : ((Object)$keyword).hashCode());
            String $charset = this.getCharset();
            result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
            return result;
        }

        @NotNull
        @Generated
        public String toString() {
            return "LogMetric.Rule(enable=" + this.isEnable() + ", file=" + this.getFile() + ", minGrow=" + String.valueOf(this.getMinGrow()) + ", maxGrow=" + String.valueOf(this.getMaxGrow()) + ", maxSize=" + String.valueOf(this.getMaxSize()) + ", bound=" + this.getBound() + ", level=" + String.valueOf(this.getLevel()) + ", keyword=" + String.valueOf(this.getKeyword()) + ", preview=" + this.getPreview() + ", section=" + this.getSection() + ", charset=" + this.getCharset() + ", clean=" + this.getClean() + ")";
        }
    }
}

