/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.monitor.report;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.wings.silencer.datetime.DateTimePattern;
import pro.fessional.wings.slardar.context.Now;
import pro.fessional.wings.slardar.monitor.WarnMetric;
import pro.fessional.wings.slardar.monitor.WarnReport;
import pro.fessional.wings.slardar.notice.DingTalkConf;
import pro.fessional.wings.slardar.notice.DingTalkNotice;

public class DingTalkReport
implements WarnReport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DingTalkReport.class);
    private final String dingConfig;
    private final DingTalkNotice dingTalkNotice;
    private final AtomicLong counter = new AtomicLong(1L);
    protected String gitInfo = null;

    public DingTalkReport(DingTalkNotice notice, String config) {
        this.dingTalkNotice = notice;
        this.dingConfig = config;
    }

    @Override
    public WarnReport.Sts report(String appName, String jvmName, Map<String, List<WarnMetric.Warn>> warn) {
        boolean rst;
        DingTalkConf conf = this.dingTalkNotice.provideConfig(this.dingConfig, true);
        String host = conf.getValidWebhook();
        if (host == null) {
            log.debug("bad webhook, skip");
            return WarnReport.Sts.Skip;
        }
        if (host.contains("${")) {
            log.debug("accessToken has placeholder, skip");
            return WarnReport.Sts.Skip;
        }
        if (warn.isEmpty()) {
            log.debug("warning is empty, skip");
            return WarnReport.Sts.Skip;
        }
        String text = this.buildMkContent(appName, jvmName, sb -> {
            for (Map.Entry entry : warn.entrySet()) {
                this.mkTitleH2((StringBuilder)sb, (String)entry.getKey());
                for (WarnMetric.Warn w : (List)entry.getValue()) {
                    if (w.getType() == WarnMetric.Type.Link) {
                        this.mkItemLink((StringBuilder)sb, w);
                        continue;
                    }
                    this.mkItemText((StringBuilder)sb, w);
                }
            }
        });
        Object subject = appName;
        if (StringUtils.isNotEmpty((CharSequence)conf.getNoticeKeyword())) {
            subject = (String)subject + " " + conf.getNoticeKeyword();
        }
        return (rst = this.dingTalkNotice.send(conf, (String)subject + " #" + this.counter.getAndIncrement(), text)) ? WarnReport.Sts.Done : WarnReport.Sts.Fail;
    }

    public String buildMkContent(String app, String jvm, Consumer<StringBuilder> builder) {
        StringBuilder sb = new StringBuilder();
        this.mkTitleH2(sb, app);
        this.mkItemText(sb, jvm, "jvm-name");
        this.mkItemText(sb, this.gitInfo, "git-info");
        this.mkItemText(sb, DateTimePattern.FMT_FULL_19Z.format(Now.zonedDateTime()), "rpt-time");
        builder.accept(sb);
        return sb.toString();
    }

    protected void mkTitleH2(StringBuilder sb, String str) {
        if (str == null) {
            return;
        }
        sb.append("\n\n## \u25a0 ").append(str);
    }

    protected void mkItemText(StringBuilder sb, String value, String key) {
        if (value == null) {
            return;
        }
        sb.append("\n- ").append(value).append(" | ").append(key);
    }

    protected void mkItemText(StringBuilder sb, WarnMetric.Warn warn) {
        sb.append("\n- ").append("**").append(warn.getWarn()).append("** | ").append(warn.getRule()).append(" | ").append(warn.getKey());
    }

    protected void mkItemLink(StringBuilder sb, WarnMetric.Warn warn) {
        sb.append("\n- [").append(warn.getRule()).append("](").append(warn.getWarn()).append(") | ").append(warn.getKey());
    }

    @Generated
    public String getDingConfig() {
        return this.dingConfig;
    }

    @Generated
    public DingTalkNotice getDingTalkNotice() {
        return this.dingTalkNotice;
    }

    @Generated
    public AtomicLong getCounter() {
        return this.counter;
    }

    @Generated
    public String getGitInfo() {
        return this.gitInfo;
    }

    @Generated
    public void setGitInfo(String gitInfo) {
        this.gitInfo = gitInfo;
    }
}

