/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.monitor.viewer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.cache2k.Cache;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.mirana.id.Ulid;
import pro.fessional.wings.slardar.cache.cache2k.WingsCache2k;
import pro.fessional.wings.slardar.monitor.WarnFilter;
import pro.fessional.wings.slardar.monitor.WarnMetric;
import pro.fessional.wings.slardar.monitor.viewer.LogConf;

public class LogViewer
implements WarnFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogViewer.class);
    private final LogConf conf;
    private final Set<String> keys = new HashSet<String>();
    private final Cache<String, String> cache;

    public LogViewer(@NotNull LogConf conf, @NotNull Collection<String> keys) {
        this.conf = conf;
        this.cache = WingsCache2k.builder(LogViewer.class, "cache", 2000, conf.getAlive(), null, String.class, String.class).build();
        this.keys.addAll(keys);
    }

    public void view(String id, OutputStream output) throws IOException {
        if (id == null) {
            return;
        }
        String log = (String)this.cache.get((Object)id);
        if (log == null) {
            return;
        }
        File file = new File(log);
        if (!file.canRead()) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            long len = this.conf.getLength().toBytes();
            IOUtils.copyLarge((InputStream)fis, (OutputStream)output, (long)0L, (long)len);
            if (file.length() - len > 0L) {
                String more = String.format("\n\n...... %,d / %,d bytes", len, file.length());
                output.write(more.getBytes());
            }
        }
    }

    @Override
    public void filter(Map<String, List<WarnMetric.Warn>> warns) {
        ArrayList<WarnMetric.Warn> flt = new ArrayList<WarnMetric.Warn>();
        for (List<WarnMetric.Warn> list : warns.values()) {
            Iterator<WarnMetric.Warn> iter = list.iterator();
            while (iter.hasNext()) {
                WarnMetric.Warn next = iter.next();
                if (next.getType() != WarnMetric.Type.File) continue;
                if (this.canIgnoreHead(next.getWarn())) {
                    log.debug("remove ignored warning");
                    iter.remove();
                    continue;
                }
                WarnMetric.Warn wd = new WarnMetric.Warn();
                wd.setType(WarnMetric.Type.Link);
                wd.setKey(next.getKey());
                wd.setRule(next.getRule());
                String id = Ulid.next();
                this.cache.put((Object)id, (Object)next.getWarn());
                wd.setWarn(this.conf.getDomain() + this.conf.getMapping() + "?id=" + id);
                flt.add(wd);
            }
        }
        warns.entrySet().removeIf(it -> ((List)it.getValue()).isEmpty());
        if (!flt.isEmpty()) {
            List<WarnMetric.Warn> old = warns.get("wings.slardar.monitor.view");
            if (old == null) {
                warns.put("wings.slardar.monitor.view", flt);
            } else {
                old.addAll(flt);
            }
        }
    }

    protected boolean canIgnoreHead(String out) {
        boolean bl;
        Collection<String> ignores = this.conf.getIgnore().values();
        if (ignores.isEmpty()) {
            return false;
        }
        long max = this.conf.getLength().toBytes();
        File file = new File(out);
        if (file.length() > max || !file.canRead()) {
            return false;
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String line;
            int tol = 0;
            int cnt = 0;
            Pattern head = this.conf.getHeader();
            block7: while ((line = reader.readLine()) != null && max > 0L) {
                max -= (long)(line.length() + 1);
                if (this.ignoreLine(line, head)) continue;
                ++tol;
                for (String s : ignores) {
                    if (!line.contains(s)) continue;
                    ++cnt;
                    continue block7;
                }
            }
            bl = tol == cnt;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        reader.close();
        return bl;
    }

    private boolean ignoreLine(String line, Pattern head) {
        if (line.isEmpty()) {
            return true;
        }
        if (head != null && !head.matcher(line).find()) {
            return true;
        }
        for (String key : this.keys) {
            if (!line.contains(key)) continue;
            return false;
        }
        return true;
    }

    @Generated
    public LogConf getConf() {
        return this.conf;
    }
}

