/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.serialize;

import org.jetbrains.annotations.NotNull;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import pro.fessional.mirana.bits.Base64;
import pro.fessional.wings.slardar.serialize.KryoSimple;

public class KryoConversion
implements ConversionService {
    public boolean canConvert(Class<?> sourceType, @NotNull Class<?> targetType) {
        return String.class.equals(sourceType) || String.class.equals(targetType);
    }

    public boolean canConvert(TypeDescriptor sourceType, @NotNull TypeDescriptor targetType) {
        return sourceType != null && String.class.equals((Object)sourceType.getType()) || String.class.equals((Object)targetType.getType());
    }

    public <T> T convert(Object source, @NotNull Class<T> targetType) {
        if (source instanceof String) {
            byte[] bytes = Base64.decode((String)((String)source));
            return KryoSimple.readClassAndObject(bytes);
        }
        if (String.class.equals(targetType)) {
            byte[] bytes = KryoSimple.writeClassAndObject(source);
            return (T)Base64.encode((byte[])bytes);
        }
        return null;
    }

    public Object convert(Object source, TypeDescriptor sourceType, @NotNull TypeDescriptor targetType) {
        return this.convert(source, targetType.getType());
    }
}

