/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import com.alibaba.ttl.threadpool.TtlExecutors;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.task.TaskSchedulingProperties;
import org.springframework.boot.task.ThreadPoolTaskExecutorBuilder;
import org.springframework.boot.task.ThreadPoolTaskSchedulerBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ConcurrentTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.async.AsyncHelper;
import pro.fessional.wings.slardar.async.TaskSchedulerHelper;
import pro.fessional.wings.slardar.async.TtlTaskDecorator;
import pro.fessional.wings.slardar.async.TtlThreadPoolTaskScheduler;
import pro.fessional.wings.slardar.spring.prop.SlardarAsyncProp;

@EnableAsync
@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class SlardarAsyncConfiguration {
    public static final String slardarFastScheduler = "slardarFastScheduler";
    private static final Log log = LogFactory.getLog(SlardarAsyncConfiguration.class);
    private final SlardarAsyncProp asyncProp;
    private final ThreadPoolTaskSchedulerBuilder fastSchedulerBuilder;

    public SlardarAsyncConfiguration(SlardarAsyncProp asyncProp) {
        this.asyncProp = asyncProp;
        ThreadPoolTaskSchedulerBuilder builder = new ThreadPoolTaskSchedulerBuilder();
        TaskSchedulingProperties fast = asyncProp.getFast();
        builder = builder.poolSize(fast.getPool().getSize());
        TaskSchedulingProperties.Shutdown shutdown = fast.getShutdown();
        builder = builder.awaitTermination(shutdown.isAwaitTermination());
        builder = builder.awaitTerminationPeriod(shutdown.getAwaitTerminationPeriod());
        this.fastSchedulerBuilder = builder = builder.threadNamePrefix(fast.getThreadNamePrefix());
    }

    @Bean
    @Primary
    @ConditionalWingsEnabled
    public TaskDecorator ttlTaskDecorator(List<TaskDecorator> others) {
        log.info((Object)("Slardar spring-bean ttlTaskDecorator, others count=" + others.size()));
        return new TtlTaskDecorator(others);
    }

    @Bean(name={"taskExecutor"})
    @ConditionalWingsEnabled
    public Executor taskExecutor(ThreadPoolTaskExecutorBuilder builder) {
        ThreadPoolTaskExecutor bean = builder.build();
        log.info((Object)("Slardar spring-bean taskExecutor of @Async, prefix=" + bean.getThreadNamePrefix()));
        return bean;
    }

    @Bean(name={"applicationTaskExecutor"})
    @ConditionalWingsEnabled
    public AsyncTaskExecutor applicationTaskExecutor(ThreadPoolTaskExecutorBuilder builder) {
        ThreadPoolTaskExecutor bean = builder.build();
        bean.setThreadNamePrefix(this.asyncProp.getExecPrefix().getApplication());
        log.info((Object)("Slardar spring-bean applicationTaskExecutor of Callable MVC, prefix=" + bean.getThreadNamePrefix()));
        return bean;
    }

    @Bean(name={"taskScheduler"})
    @ConditionalWingsEnabled
    public ThreadPoolTaskScheduler taskScheduler(ThreadPoolTaskSchedulerBuilder builder) {
        TtlThreadPoolTaskScheduler bean = TaskSchedulerHelper.Ttl(builder);
        log.info((Object)("Slardar spring-bean taskScheduler of @Scheduled, prefix=" + bean.getThreadNamePrefix()));
        return bean;
    }

    @Bean(name={"slardarFastScheduler"})
    @ConditionalWingsEnabled
    public ThreadPoolTaskScheduler slardarFastScheduler() {
        TtlThreadPoolTaskScheduler bean = TaskSchedulerHelper.Ttl(this.fastSchedulerBuilder);
        log.info((Object)("Slardar spring-bean slardarFastScheduler of fast Scheduled, prefix=" + bean.getThreadNamePrefix()));
        return bean;
    }

    @Bean
    @ConditionalWingsEnabled
    public TaskSchedulerHelper taskSchedulerHelper(@Qualifier(value="slardarFastScheduler") ThreadPoolTaskScheduler fast, @Qualifier(value="taskScheduler") ThreadPoolTaskScheduler scheduled, ThreadPoolTaskSchedulerBuilder scheduledBuilder) {
        log.info((Object)"Slardar spring-bean taskSchedulerHelper");
        return new TaskSchedulerHelper(this, scheduled, fast, this.fastSchedulerBuilder, scheduledBuilder){};
    }

    @Bean
    @ConditionalWingsEnabled
    public AsyncHelper asyncHelper(@Qualifier(value="taskExecutor") Executor asyncExec, @Qualifier(value="applicationTaskExecutor") AsyncTaskExecutor appExec, ThreadPoolTaskExecutorBuilder executorBuilder) {
        log.info((Object)"Slardar spring-bean asyncHelper");
        ThreadPoolTaskExecutor executor = executorBuilder.build();
        executor.setThreadNamePrefix(this.asyncProp.getExecPrefix().getLite());
        executor.initialize();
        Executor exec = TtlExecutors.getTtlExecutor((Executor)executor);
        ConcurrentTaskExecutor liteExecutor = new ConcurrentTaskExecutor(exec);
        return new AsyncHelper(this, asyncExec, appExec, executorBuilder, (AsyncTaskExecutor)liteExecutor){};
    }
}

