/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import com.alibaba.ttl.threadpool.TtlExecutors;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.task.TaskExecutionProperties;
import org.springframework.boot.task.ThreadPoolTaskExecutorBuilder;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import pro.fessional.wings.silencer.runner.ApplicationStartedEventRunner;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.event.EventPublishHelper;
import pro.fessional.wings.slardar.event.attr.AttributeEventListener;
import pro.fessional.wings.slardar.spring.prop.SlardarAsyncProp;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class SlardarEventConfiguration {
    private static final Log log = LogFactory.getLog(SlardarEventConfiguration.class);
    public static final String slardarEventExecutor = "slardarEventExecutor";

    @Bean(name={"slardarEventExecutor"})
    @ConditionalWingsEnabled
    public Executor slardarEventExecutor(SlardarAsyncProp prop) {
        ThreadPoolTaskExecutorBuilder builder = new ThreadPoolTaskExecutorBuilder();
        TaskExecutionProperties event = prop.getEvent();
        TaskExecutionProperties.Pool pool = event.getPool();
        builder = builder.queueCapacity(pool.getQueueCapacity());
        builder = builder.corePoolSize(pool.getCoreSize());
        builder = builder.maxPoolSize(pool.getMaxSize());
        builder = builder.allowCoreThreadTimeOut(pool.isAllowCoreThreadTimeout());
        builder = builder.keepAlive(pool.getKeepAlive());
        TaskExecutionProperties.Shutdown shutdown = event.getShutdown();
        builder = builder.awaitTermination(shutdown.isAwaitTermination());
        builder = builder.awaitTerminationPeriod(shutdown.getAwaitTerminationPeriod());
        builder = builder.threadNamePrefix(event.getThreadNamePrefix());
        log.info((Object)("Slardar spring-bean slardarEventExecutor via TtlThreadPoolTaskExecutor, prefix=" + event.getThreadNamePrefix()));
        ThreadPoolTaskExecutor executor = builder.build();
        executor.initialize();
        return TtlExecutors.getTtlExecutor((Executor)executor);
    }

    @Bean
    @ConditionalWingsEnabled
    public ApplicationStartedEventRunner eventPublishHelperRunner(ApplicationEventPublisher publisher, ApplicationEventMulticaster multicaster, @Qualifier(value="slardarEventExecutor") Executor executor) {
        log.info((Object)"Slardar spring-runs eventPublishHelperRunner");
        return new ApplicationStartedEventRunner(-30000000, ignored -> {
            EventPublishHelper.prepareAsyncExecutor(executor);
            log.info((Object)("Slardar conf eventPublishHelper ApplicationEventPublisher=" + String.valueOf(publisher.getClass())));
            EventPublishHelper.prepareSpringPublisher(publisher);
            log.info((Object)("Slardar conf eventPublishHelper ApplicationEventMulticaster=" + String.valueOf(multicaster.getClass())));
            if (multicaster instanceof SimpleApplicationEventMulticaster) {
                SimpleApplicationEventMulticaster mc = (SimpleApplicationEventMulticaster)multicaster;
                try {
                    Method getErrorHandler;
                    Method getTaskExecutor = BeanUtils.findMethod(SimpleApplicationEventMulticaster.class, (String)"getTaskExecutor", (Class[])new Class[0]);
                    if (getTaskExecutor != null) {
                        getTaskExecutor.setAccessible(true);
                        Object te = getTaskExecutor.invoke((Object)mc, new Object[0]);
                        if (te != null) {
                            log.warn((Object)"Slardar conf eventPublishHelper SimpleApplicationEventMulticaster should without TaskExecutor");
                        }
                    }
                    if ((getErrorHandler = BeanUtils.findMethod(SimpleApplicationEventMulticaster.class, (String)"getErrorHandler", (Class[])new Class[0])) != null) {
                        getErrorHandler.setAccessible(true);
                        Object eh = getErrorHandler.invoke((Object)mc, new Object[0]);
                        if (eh != null) {
                            log.warn((Object)"Slardar conf eventPublishHelper SimpleApplicationEventMulticaster should without ErrorHandler");
                        }
                    }
                }
                catch (Exception e) {
                    log.info((Object)"failed to check SimpleApplicationEventMulticaster", (Throwable)e);
                }
            }
        });
    }

    @Bean
    @ConditionalWingsEnabled
    public AttributeEventListener attributeEventListener() {
        log.info((Object)"Slardar spring-bean AttributeEventListener");
        return new AttributeEventListener();
    }
}

