/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.slardar.spring.bean;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.ConnectionPool;
import okhttp3.CookieJar;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.httprest.okhttp.OkHttpClientBuilder;
import pro.fessional.wings.slardar.httprest.okhttp.OkHttpHostCookie;
import pro.fessional.wings.slardar.httprest.okhttp.OkHttpInterceptor;
import pro.fessional.wings.slardar.httprest.okhttp.OkHttpRedirectNopInterceptor;
import pro.fessional.wings.slardar.spring.prop.SlardarOkhttpProp;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={OkHttpClient.class})
@ConditionalWingsEnabled
public class SlardarOkhttpConfiguration {
    private static final Log log = LogFactory.getLog(SlardarOkhttpConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public ConnectionPool okhttpConnectionPool(SlardarOkhttpProp config) {
        log.info((Object)"Slardar spring-bean okhttp3ConnectionPool");
        int maxIdleConnections = config.getMaxIdle();
        return new ConnectionPool(maxIdleConnections, (long)config.getKeepAlive(), TimeUnit.SECONDS);
    }

    @Bean
    @ConditionalWingsEnabled
    public CookieJar okhttpHostCookieJar() {
        log.info((Object)"Slardar spring-bean okhttpHostCookieJar");
        return new OkHttpHostCookie();
    }

    @Bean
    @ConditionalWingsEnabled
    @ConditionalOnExpression(value="${wings.slardar.okhttp.follow-redirect:false} || ${wings.slardar.okhttp.follow-redirect-ssl:false}")
    @Order(value=-30000000)
    public OkHttpRedirectNopInterceptor okhttpRedirectNopInterceptor() {
        log.info((Object)"Slardar spring-bean okhttpRedirectNopInterceptor");
        return new OkHttpRedirectNopInterceptor();
    }

    @Bean
    @ConditionalWingsEnabled
    public OkHttpClient.Builder okhttpClientBuilder(ObjectProvider<Cache> cacheProvider, ObjectProvider<CookieJar> cookieProvider, ObjectProvider<Dns> dnsProvider, ConnectionPool connectionPool, ObjectProvider<Interceptor> interceptors, SlardarOkhttpProp properties) {
        Dns dns;
        log.info((Object)"Slardar spring-bean okhttpClientBuilder");
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(Duration.ofSeconds(properties.getTimeoutConn())).readTimeout(Duration.ofSeconds(properties.getTimeoutRead())).writeTimeout(Duration.ofSeconds(properties.getTimeoutWrite())).pingInterval(Duration.ofSeconds(properties.getPingInterval())).followRedirects(properties.isFollowRedirect()).followSslRedirects(properties.isFollowRedirectSsl()).retryOnConnectionFailure(properties.isRetryFailure());
        interceptors.orderedStream().forEach(it -> {
            if (it instanceof OkHttpInterceptor && ((OkHttpInterceptor)it).isNetwork()) {
                log.info((Object)("Slardar conf okhttpClient addNetworkInterceptor:" + String.valueOf(it.getClass())));
                builder.addNetworkInterceptor(it);
            } else {
                log.info((Object)("Slardar conf okhttpClient addInterceptor:" + String.valueOf(it.getClass())));
                builder.addInterceptor(it);
            }
        });
        Cache cacheBean = (Cache)cacheProvider.getIfAvailable();
        if (cacheBean == null) {
            int mbs = properties.getCacheMegabyte();
            if (mbs > 0) {
                File cacheDir = properties.getCacheDirectory();
                try {
                    if (cacheDir == null) {
                        cacheDir = Files.createTempDirectory("wings-okhttp-cache", new FileAttribute[0]).toFile();
                    }
                    builder.cache(new Cache(cacheDir, (long)mbs * 1024L * 1024L));
                }
                catch (Exception e) {
                    log.warn((Object)("failed to create okhttp cache on dir=" + String.valueOf(cacheDir)), (Throwable)e);
                }
                log.info((Object)("Slardar conf okhttpClient cache-dir=" + String.valueOf(properties.getCacheDirectory())));
            } else {
                log.info((Object)"Slardar conf okhttpClient no-cache");
            }
        } else {
            builder.cache(cacheBean);
            log.info((Object)("Slardar conf okhttpClient cache=" + cacheBean.getClass().getName()));
        }
        builder.connectionPool(connectionPool);
        CookieJar ck = (CookieJar)cookieProvider.getIfAvailable();
        if (ck != null) {
            log.info((Object)("Slardar conf okhttpClient CookieJar=" + ck.getClass().getName()));
            builder.cookieJar(ck);
        }
        if ((dns = (Dns)dnsProvider.getIfAvailable()) != null) {
            log.info((Object)("Slardar conf okhttpClient dns=" + dns.getClass().getName()));
            builder.dns(dns);
        }
        if (properties.isSslTrustAll()) {
            log.info((Object)"Slardar conf okhttpClient sslTrustAll");
            OkHttpClientBuilder.sslTrustAll(builder);
        }
        return builder;
    }

    @Bean
    @ConditionalWingsEnabled
    public OkHttpClient okhttpClient(OkHttpClient.Builder builder) {
        log.info((Object)"Slardar spring-bean okhttpClient");
        return builder.build();
    }
}

