/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.testing.batrider.controller;

import lombok.Generated;
import org.apache.servicecomb.provider.pojo.Invoker;
import org.apache.servicecomb.provider.pojo.RpcReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import pro.fessional.wings.testing.batrider.contract.TestingHelloContract;

@RestController
public class TestingBatriderController {
    private final TestingHelloContract testingHelloContractProxy = (TestingHelloContract)Invoker.createProxy((String)"batrider", (String)"batrider-hello", TestingHelloContract.class);
    private TestingHelloContract testingHelloContractRpc;
    private RestTemplate restTemplate;

    @RequestMapping(path={"/batrider/winx-hello-rpc"}, method={RequestMethod.GET})
    public String winxHelloRpc(@RequestParam(name="name") String name) {
        return this.testingHelloContractRpc.sayHello(name);
    }

    @RequestMapping(path={"/batrider/winx-hello-cse"}, method={RequestMethod.GET})
    public String winxHelloCse(@RequestParam(name="name") String name) {
        return (String)this.restTemplate.getForObject("cse://winx-api/winx-hello/say-hello?name=" + name, String.class, new Object[0]);
    }

    @RequestMapping(path={"/batrider/batx-hello-pxy"}, method={RequestMethod.GET})
    public String batriderHelloPxy(@RequestParam(name="name") String name) {
        return this.testingHelloContractProxy.sayHello(name);
    }

    @RpcReference(microserviceName="winx-api", schemaId="winx-hello")
    @Generated
    public void setTestingHelloContractRpc(TestingHelloContract testingHelloContractRpc) {
        this.testingHelloContractRpc = testingHelloContractRpc;
    }

    @Autowired
    @Generated
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

