/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.testing.faceless.database;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import pro.fessional.mirana.data.Diff;
import pro.fessional.mirana.io.InputStreams;
import pro.fessional.wings.faceless.database.DataSourceContext;

public class TestingDatabaseHelper {
    private static final Logger log = LoggerFactory.getLogger(TestingDatabaseHelper.class);
    private final DataSourceContext dataSourceContext;
    private final boolean hasH2;

    public TestingDatabaseHelper(DataSourceContext context) {
        this.dataSourceContext = context;
        boolean h2 = false;
        for (String s : context.getBackends().keySet()) {
            if (!s.contains(":h2:") && !s.contains(":H2:")) continue;
            h2 = true;
            break;
        }
        this.hasH2 = h2;
    }

    public boolean hasH2() {
        return this.hasH2;
    }

    public DataSourceContext getDataSourceContext() {
        return this.dataSourceContext;
    }

    public void cleanTable() {
        for (Map.Entry en : this.dataSourceContext.getBackends().entrySet()) {
            this.cleanTable((DataSource)en.getValue(), (String)en.getKey());
        }
    }

    public void cleanTable(DataSource dataSource, String info) {
        TestingDatabaseHelper.testcaseNotice("clean database " + info);
        JdbcTemplate tmpl = new JdbcTemplate(dataSource);
        tmpl.query("SHOW TABLES", rs -> {
            String tbl = rs.getString(1);
            TestingDatabaseHelper.testcaseNotice("DROP TABLE " + tbl);
            tmpl.execute("DROP TABLE `" + tbl + "`");
        });
    }

    public void assertSame(Type type, String ... str) {
        List<String> bSet = this.lowerCase(str);
        AtomicBoolean good = new AtomicBoolean(true);
        this.fetchAllColumn1(type.sql).forEach((k, aSet) -> {
            Diff.S diff = Diff.of((Collection)aSet, (Collection)bSet);
            if (!diff.bNotA.isEmpty()) {
                TestingDatabaseHelper.testcaseNotice(k + " less in db " + String.valueOf((Object)type) + ":" + String.join((CharSequence)",", diff.bNotA));
                good.set(false);
            }
            if (!diff.aNotB.isEmpty()) {
                TestingDatabaseHelper.testcaseNotice(k + " more in db " + String.valueOf((Object)type) + ":" + String.join((CharSequence)",", diff.aNotB));
                good.set(false);
            }
        });
        Assertions.assertTrue((boolean)good.get(), (String)(type.name() + " difference, check the logs."));
    }

    public void assertHas(Type type, String ... str) {
        List<String> bSet = this.lowerCase(str);
        AtomicBoolean good = new AtomicBoolean(true);
        this.fetchAllColumn1(type.sql).forEach((k, aSet) -> {
            Diff.S diff = Diff.of((Collection)aSet, (Collection)bSet);
            if (!diff.bNotA.isEmpty()) {
                TestingDatabaseHelper.testcaseNotice(k + " less in db " + String.valueOf((Object)type) + ":" + String.join((CharSequence)",", diff.bNotA));
                good.set(false);
            }
        });
        Assertions.assertTrue((boolean)good.get(), (String)(type.name() + " difference, check the logs."));
    }

    public void assertNot(Type type, String ... str) {
        List<String> bSet = this.lowerCase(str);
        AtomicBoolean good = new AtomicBoolean(true);
        this.fetchAllColumn1(type.sql).forEach((k, aSet) -> {
            Diff.S diff = Diff.of((Collection)aSet, (Collection)bSet);
            if (diff.bNotA.size() != bSet.size()) {
                TestingDatabaseHelper.testcaseNotice(k + " cant in db " + String.valueOf((Object)type) + ":" + String.join((CharSequence)",", diff.bNotA));
                good.set(false);
            }
        });
        Assertions.assertTrue((boolean)good.get(), (String)(type.name() + " difference, check the logs."));
    }

    private List<String> lowerCase(String ... str) {
        return Arrays.stream(str).map(String::toLowerCase).collect(Collectors.toList());
    }

    private Map<String, Set<String>> fetchAllColumn1(String sql) {
        LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
        for (Map.Entry en : this.dataSourceContext.getBackends().entrySet()) {
            List col = new JdbcTemplate((DataSource)en.getValue()).query(sql, (rs, ignored) -> rs.getString(1).toLowerCase());
            result.put((String)en.getKey(), new LinkedHashSet(col));
        }
        return result;
    }

    public static void testcaseNotice(String ... mes) {
        for (String s : mes) {
            log.info(">>=>\ud83e\udd81\ud83e\udd81\ud83e\udd81 " + s + " \ud83e\udd81\ud83e\udd81\ud83e\udd81<=<<");
        }
    }

    public static void breakpointDebug(String ... mes) {
        Arrays.stream(mes).forEach(s -> log.debug(">>=>\ud83d\udc36\ud83d\udc36\ud83d\udc36 " + s + " \ud83d\udc36\ud83d\udc36\ud83d\udc36<=<<"));
    }

    public static void execWingsSql(JdbcTemplate jdbcTemplate, String path) {
        String sqls = InputStreams.readText((InputStream)TestingDatabaseHelper.class.getResourceAsStream("/wings-flywave/" + path));
        for (String sql : sqls.split(";+[ \\t]*[\\r\\n]+|;+[ \\t]*--[^\\r\\n]+[\\r\\n]+|;+[ \\t]*/\\*[^\\r\\n]+\\*/[ \\t]*[\\r\\n]+")) {
            String s = sql.trim();
            if (s.isEmpty()) continue;
            jdbcTemplate.execute(s);
        }
    }

    public static enum Type {
        Table("SHOW TABLES"),
        Trigger("SELECT TRIGGER_NAME FROM INFORMATION_SCHEMA.TRIGGERS WHERE EVENT_OBJECT_SCHEMA = SCHEMA()");

        private final String sql;

        private Type(String sql) {
            this.sql = sql;
        }
    }
}

