/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.testing.silencer;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.junit.jupiter.api.Assertions;
import org.slf4j.LoggerFactory;

public class TestingLoggerAssert
extends AppenderBase<ILoggingEvent> {
    private final Map<String, Predicate<ILoggingEvent>> rules = new LinkedHashMap<String, Predicate<ILoggingEvent>>();
    private final Map<String, Integer> count = new LinkedHashMap<String, Integer>();

    public static TestingLoggerAssert install() {
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        TestingLoggerAssert memoryAppender = new TestingLoggerAssert();
        memoryAppender.setContext((Context)((LoggerContext)LoggerFactory.getILoggerFactory()));
        root.addAppender((Appender)memoryAppender);
        return memoryAppender;
    }

    @Contract(value="_,_->this")
    public TestingLoggerAssert rule(String name, Predicate<ILoggingEvent> rule) {
        this.rules.put(name, rule);
        this.count.put(name, 0);
        return this;
    }

    protected void append(ILoggingEvent event) {
        if (!this.isStarted()) {
            return;
        }
        for (Map.Entry<String, Predicate<ILoggingEvent>> en : this.rules.entrySet()) {
            if (!en.getValue().test(event)) continue;
            this.count.compute(en.getKey(), (s, c) -> c == null ? 1 : c + 1);
        }
    }

    public Map<String, Integer> getAssertCount() {
        return this.count;
    }

    public int getAssertCount(String name) {
        Integer c = this.count.get(name);
        return c == null ? 0 : c;
    }

    public void assertCount(int min) {
        for (Integer c : this.count.values()) {
            Assertions.assertTrue((c != null && c >= min ? 1 : 0) != 0, this::messageCount);
        }
    }

    public String messageCount() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> en : this.count.entrySet()) {
            sb.append(",").append(en.getKey()).append(":").append(en.getValue());
        }
        return sb.isEmpty() ? "" : sb.substring(1);
    }

    public void resetAll() {
        this.rules.clear();
        this.count.clear();
    }

    public void resetCount() {
        this.count.clear();
    }

    public void uninstall() {
        this.resetAll();
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        Iterator iter = root.iteratorForAppenders();
        while (iter.hasNext()) {
            Appender apd = (Appender)iter.next();
            if (apd != this) continue;
            root.detachAppender(apd);
        }
    }
}

