/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.testing.silencer.data;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.wings.testing.silencer.data.DefaultData;

public class PrimitiveValue
implements DefaultData<PrimitiveValue> {
    public static final float FloatPip = (float)Math.PI;
    public static final float FloatPin = (float)(-Math.PI);
    public static final double DoublePip = Math.PI;
    public static final double DoublePin = -Math.PI;
    private boolean boolFalse = true;
    private boolean boolTrue = false;
    private byte byteMin = 0;
    private byte byteMax = 0;
    private char charMin = '\u0000';
    private char charMax = '\u0000';
    private short shortMin = 0;
    private short shortMax = 0;
    private int intMin = 0;
    private int intMax = 0;
    private long longMin = 0L;
    private long longMax = 0L;
    private float floatPip = 0.0f;
    private float floatPin = 0.0f;
    private double doublePip = 0.0;
    private double doublePin = 0.0;

    @Override
    public PrimitiveValue defaults() {
        this.boolFalse = false;
        this.boolTrue = true;
        this.byteMin = (byte)-128;
        this.byteMax = (byte)127;
        this.charMin = '\u0000';
        this.charMax = (char)65535;
        this.shortMin = Short.MIN_VALUE;
        this.shortMax = Short.MAX_VALUE;
        this.intMin = Integer.MIN_VALUE;
        this.intMax = Integer.MAX_VALUE;
        this.longMin = Long.MIN_VALUE;
        this.longMax = Long.MAX_VALUE;
        this.floatPip = (float)Math.PI;
        this.floatPin = (float)(-Math.PI);
        this.doublePip = Math.PI;
        this.doublePin = -Math.PI;
        return this;
    }

    @Generated
    public PrimitiveValue() {
    }

    @Generated
    public boolean isBoolFalse() {
        return this.boolFalse;
    }

    @Generated
    public boolean isBoolTrue() {
        return this.boolTrue;
    }

    @Generated
    public byte getByteMin() {
        return this.byteMin;
    }

    @Generated
    public byte getByteMax() {
        return this.byteMax;
    }

    @Generated
    public char getCharMin() {
        return this.charMin;
    }

    @Generated
    public char getCharMax() {
        return this.charMax;
    }

    @Generated
    public short getShortMin() {
        return this.shortMin;
    }

    @Generated
    public short getShortMax() {
        return this.shortMax;
    }

    @Generated
    public int getIntMin() {
        return this.intMin;
    }

    @Generated
    public int getIntMax() {
        return this.intMax;
    }

    @Generated
    public long getLongMin() {
        return this.longMin;
    }

    @Generated
    public long getLongMax() {
        return this.longMax;
    }

    @Generated
    public float getFloatPip() {
        return this.floatPip;
    }

    @Generated
    public float getFloatPin() {
        return this.floatPin;
    }

    @Generated
    public double getDoublePip() {
        return this.doublePip;
    }

    @Generated
    public double getDoublePin() {
        return this.doublePin;
    }

    @Generated
    public void setBoolFalse(boolean boolFalse) {
        this.boolFalse = boolFalse;
    }

    @Generated
    public void setBoolTrue(boolean boolTrue) {
        this.boolTrue = boolTrue;
    }

    @Generated
    public void setByteMin(byte byteMin) {
        this.byteMin = byteMin;
    }

    @Generated
    public void setByteMax(byte byteMax) {
        this.byteMax = byteMax;
    }

    @Generated
    public void setCharMin(char charMin) {
        this.charMin = charMin;
    }

    @Generated
    public void setCharMax(char charMax) {
        this.charMax = charMax;
    }

    @Generated
    public void setShortMin(short shortMin) {
        this.shortMin = shortMin;
    }

    @Generated
    public void setShortMax(short shortMax) {
        this.shortMax = shortMax;
    }

    @Generated
    public void setIntMin(int intMin) {
        this.intMin = intMin;
    }

    @Generated
    public void setIntMax(int intMax) {
        this.intMax = intMax;
    }

    @Generated
    public void setLongMin(long longMin) {
        this.longMin = longMin;
    }

    @Generated
    public void setLongMax(long longMax) {
        this.longMax = longMax;
    }

    @Generated
    public void setFloatPip(float floatPip) {
        this.floatPip = floatPip;
    }

    @Generated
    public void setFloatPin(float floatPin) {
        this.floatPin = floatPin;
    }

    @Generated
    public void setDoublePip(double doublePip) {
        this.doublePip = doublePip;
    }

    @Generated
    public void setDoublePin(double doublePin) {
        this.doublePin = doublePin;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrimitiveValue)) {
            return false;
        }
        PrimitiveValue other = (PrimitiveValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBoolFalse() != other.isBoolFalse()) {
            return false;
        }
        if (this.isBoolTrue() != other.isBoolTrue()) {
            return false;
        }
        if (this.getByteMin() != other.getByteMin()) {
            return false;
        }
        if (this.getByteMax() != other.getByteMax()) {
            return false;
        }
        if (this.getCharMin() != other.getCharMin()) {
            return false;
        }
        if (this.getCharMax() != other.getCharMax()) {
            return false;
        }
        if (this.getShortMin() != other.getShortMin()) {
            return false;
        }
        if (this.getShortMax() != other.getShortMax()) {
            return false;
        }
        if (this.getIntMin() != other.getIntMin()) {
            return false;
        }
        if (this.getIntMax() != other.getIntMax()) {
            return false;
        }
        if (this.getLongMin() != other.getLongMin()) {
            return false;
        }
        if (this.getLongMax() != other.getLongMax()) {
            return false;
        }
        if (Float.compare(this.getFloatPip(), other.getFloatPip()) != 0) {
            return false;
        }
        if (Float.compare(this.getFloatPin(), other.getFloatPin()) != 0) {
            return false;
        }
        if (Double.compare(this.getDoublePip(), other.getDoublePip()) != 0) {
            return false;
        }
        return Double.compare(this.getDoublePin(), other.getDoublePin()) == 0;
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof PrimitiveValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBoolFalse() ? 79 : 97);
        result = result * 59 + (this.isBoolTrue() ? 79 : 97);
        result = result * 59 + this.getByteMin();
        result = result * 59 + this.getByteMax();
        result = result * 59 + this.getCharMin();
        result = result * 59 + this.getCharMax();
        result = result * 59 + this.getShortMin();
        result = result * 59 + this.getShortMax();
        result = result * 59 + this.getIntMin();
        result = result * 59 + this.getIntMax();
        long $longMin = this.getLongMin();
        result = result * 59 + (int)($longMin >>> 32 ^ $longMin);
        long $longMax = this.getLongMax();
        result = result * 59 + (int)($longMax >>> 32 ^ $longMax);
        result = result * 59 + Float.floatToIntBits(this.getFloatPip());
        result = result * 59 + Float.floatToIntBits(this.getFloatPin());
        long $doublePip = Double.doubleToLongBits(this.getDoublePip());
        result = result * 59 + (int)($doublePip >>> 32 ^ $doublePip);
        long $doublePin = Double.doubleToLongBits(this.getDoublePin());
        result = result * 59 + (int)($doublePin >>> 32 ^ $doublePin);
        return result;
    }

    @NotNull
    @Generated
    public String toString() {
        return "PrimitiveValue(boolFalse=" + this.isBoolFalse() + ", boolTrue=" + this.isBoolTrue() + ", byteMin=" + this.getByteMin() + ", byteMax=" + this.getByteMax() + ", charMin=" + this.getCharMin() + ", charMax=" + this.getCharMax() + ", shortMin=" + this.getShortMin() + ", shortMax=" + this.getShortMax() + ", intMin=" + this.getIntMin() + ", intMax=" + this.getIntMax() + ", longMin=" + this.getLongMin() + ", longMax=" + this.getLongMax() + ", floatPip=" + this.getFloatPip() + ", floatPin=" + this.getFloatPin() + ", doublePip=" + this.getDoublePip() + ", doublePin=" + this.getDoublePin() + ")";
    }
}

