/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.grow.track;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.function.SingletonSupplier;
import pro.fessional.mirana.func.Lam;
import pro.fessional.mirana.pain.ThrowableUtil;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.silencer.spring.help.ApplicationContextHelper;
import pro.fessional.wings.tiny.grow.track.TinyTrackService;
import pro.fessional.wings.tiny.grow.track.TinyTracking;

public class TinyTrackHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TinyTrackHelper.class);
    private static final SingletonSupplier<TinyTrackService> TrackService = ApplicationContextHelper.getSingletonSupplier(TinyTrackService.class);

    public static <R> R track(@NotNull Lam.Ref key, @NotNull Function<TinyTracking, R> fun) {
        return TinyTrackHelper.track(key.method, fun);
    }

    public static <R> R track(@NotNull Method key, @NotNull Function<TinyTracking, R> fun) {
        TinyTrackService service = (TinyTrackService)TrackService.obtain();
        TinyTracking tracking = service.begin(key);
        return TinyTrackHelper.track(service, tracking, fun);
    }

    public static <R> R track(@NotNull Enum<?> key, @NotNull Function<TinyTracking, R> fun) {
        TinyTrackService service = (TinyTrackService)TrackService.obtain();
        TinyTracking tracking = service.begin(key);
        return TinyTrackHelper.track(service, tracking, fun);
    }

    public static <R> R track(@NotNull String key, @NotNull Function<TinyTracking, R> fun) {
        TinyTrackService service = (TinyTrackService)TrackService.obtain();
        TinyTracking tracking = service.begin(key);
        return TinyTrackHelper.track(service, tracking, fun);
    }

    public static <R> R track(@NotNull String key, @NotNull String ref, @NotNull Function<TinyTracking, R> fun) {
        TinyTrackService service = (TinyTrackService)TrackService.obtain();
        TinyTracking tracking = service.begin(key, ref);
        return TinyTrackHelper.track(service, tracking, fun);
    }

    private static <R> R track(@NotNull TinyTrackService service, @NotNull TinyTracking tracking, @NotNull Function<TinyTracking, R> fun) {
        try {
            R out = fun.apply(tracking);
            if (tracking.getOut() == null) {
                tracking.setOut(out);
            }
            R r = out;
            return r;
        }
        catch (Throwable e) {
            if (tracking.getErr() == null) {
                tracking.setErr(e);
            }
            throw ThrowableUtil.runtime((Throwable)e);
        }
        finally {
            tracking.setElapse(ThreadNow.millis() - tracking.getBegin());
            service.track(tracking, true);
        }
    }

    public static TrackWrapper track(@NotNull Lam.Ref key) {
        return TinyTrackHelper.track(key.method);
    }

    public static TrackWrapper track(@NotNull Method key) {
        TinyTrackService service = (TinyTrackService)TrackService.obtain();
        TinyTracking tracking = service.begin(key);
        return new TrackWrapper(tracking, service);
    }

    public static TrackWrapper track(@NotNull Enum<?> key) {
        TinyTrackService service = (TinyTrackService)TrackService.obtain();
        TinyTracking tracking = service.begin(key);
        return new TrackWrapper(tracking, service);
    }

    public static TrackWrapper track(@NotNull String key) {
        TinyTrackService service = (TinyTrackService)TrackService.obtain();
        TinyTracking tracking = service.begin(key);
        return new TrackWrapper(tracking, service);
    }

    public static TrackWrapper track(@NotNull String key, @NotNull String ref) {
        TinyTrackService service = (TinyTrackService)TrackService.obtain();
        TinyTracking tracking = service.begin(key, ref);
        return new TrackWrapper(tracking, service);
    }

    public static class TrackWrapper
    implements AutoCloseable {
        @NotNull
        private final TinyTracking tracking;
        @NotNull
        private final TinyTrackService service;

        public void safeSet(@NotNull Consumer<TinyTracking> fun) {
            try {
                fun.accept(this.tracking);
            }
            catch (Throwable e) {
                log.warn("safeSet get error", e);
            }
        }

        public <R> R safeOut(@NotNull Function<TinyTracking, R> fun) {
            R out = null;
            try {
                out = fun.apply(this.tracking);
                this.tracking.setOut(out);
            }
            catch (Throwable e) {
                log.warn("safeOut get error", e);
            }
            return out;
        }

        @Override
        public void close() {
            this.tracking.setElapse(ThreadNow.millis() - this.tracking.getBegin());
            this.service.track(this.tracking, true);
        }

        @Generated
        public TrackWrapper(@NotNull TinyTracking tracking, @NotNull TinyTrackService service) {
            if (tracking == null) {
                throw new NullPointerException("tracking is marked non-null but is null");
            }
            if (service == null) {
                throw new NullPointerException("service is marked non-null but is null");
            }
            this.tracking = tracking;
            this.service = service;
        }

        @NotNull
        @Generated
        public TinyTracking getTracking() {
            return this.tracking;
        }

        @NotNull
        @Generated
        public TinyTrackService getService() {
            return this.service;
        }

        @Generated
        public void setIns(Object ... ins) {
            this.getTracking().setIns(ins);
        }

        @Generated
        public void addEnv(String key, Object value) {
            this.getTracking().addEnv(key, value);
        }

        @Generated
        public void addEnv(Map<String, Object> envs) {
            this.getTracking().addEnv(envs);
        }

        @Generated
        public void addOmit(Object omit) {
            this.getTracking().addOmit(omit);
        }

        @Generated
        public long getBegin() {
            return this.getTracking().getBegin();
        }

        @Generated
        public String getKey() {
            return this.getTracking().getKey();
        }

        @Generated
        public String getRef() {
            return this.getTracking().getRef();
        }

        @Generated
        public String getApp() {
            return this.getTracking().getApp();
        }

        @Generated
        public Map<String, Object> getEnv() {
            return this.getTracking().getEnv();
        }

        @Generated
        public Object[] getIns() {
            return this.getTracking().getIns();
        }

        @Generated
        public Object getOut() {
            return this.getTracking().getOut();
        }

        @Generated
        public Throwable getErr() {
            return this.getTracking().getErr();
        }

        @Generated
        public long getElapse() {
            return this.getTracking().getElapse();
        }

        @Generated
        public long getUserKey() {
            return this.getTracking().getUserKey();
        }

        @Generated
        public long getUserRef() {
            return this.getTracking().getUserRef();
        }

        @Generated
        public long getDataKey() {
            return this.getTracking().getDataKey();
        }

        @Generated
        public long getDataRef() {
            return this.getTracking().getDataRef();
        }

        @Generated
        public long getDataOpt() {
            return this.getTracking().getDataOpt();
        }

        @Generated
        public String getCodeKey() {
            return this.getTracking().getCodeKey();
        }

        @Generated
        public String getCodeRef() {
            return this.getTracking().getCodeRef();
        }

        @Generated
        public String getCodeOpt() {
            return this.getTracking().getCodeOpt();
        }

        @Generated
        public String getWordRef() {
            return this.getTracking().getWordRef();
        }

        @Generated
        public Set<Object> getOmitRule() {
            return this.getTracking().getOmitRule();
        }

        @Generated
        public void setApp(String app) {
            this.getTracking().setApp(app);
        }

        @Generated
        public void setEnv(Map<String, Object> env) {
            this.getTracking().setEnv(env);
        }

        @Generated
        public void setOut(Object out) {
            this.getTracking().setOut(out);
        }

        @Generated
        public void setErr(Throwable err) {
            this.getTracking().setErr(err);
        }

        @Generated
        public void setElapse(long elapse) {
            this.getTracking().setElapse(elapse);
        }

        @Generated
        public void setUserKey(long userKey) {
            this.getTracking().setUserKey(userKey);
        }

        @Generated
        public void setUserRef(long userRef) {
            this.getTracking().setUserRef(userRef);
        }

        @Generated
        public void setDataKey(long dataKey) {
            this.getTracking().setDataKey(dataKey);
        }

        @Generated
        public void setDataRef(long dataRef) {
            this.getTracking().setDataRef(dataRef);
        }

        @Generated
        public void setDataOpt(long dataOpt) {
            this.getTracking().setDataOpt(dataOpt);
        }

        @Generated
        public void setCodeKey(String codeKey) {
            this.getTracking().setCodeKey(codeKey);
        }

        @Generated
        public void setCodeRef(String codeRef) {
            this.getTracking().setCodeRef(codeRef);
        }

        @Generated
        public void setCodeOpt(String codeOpt) {
            this.getTracking().setCodeOpt(codeOpt);
        }

        @Generated
        public void setWordRef(String wordRef) {
            this.getTracking().setWordRef(wordRef);
        }
    }
}

