/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.grow.track.impl;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import pro.fessional.mirana.cast.MethodConvertor;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.tiny.grow.track.TinyTrackService;
import pro.fessional.wings.tiny.grow.track.TinyTracker;
import pro.fessional.wings.tiny.grow.track.TinyTracking;

@Aspect
@Component
@ConditionalWingsEnabled
@Order(value=-50000000)
public class TinyTrackAround {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TinyTrackAround.class);
    protected TinyTrackService tinyTrackService;
    private final ConcurrentHashMap<Method, Set<Object>> omitRules = new ConcurrentHashMap();
    private final ConcurrentHashMap<Method, Method> mixMethod = new ConcurrentHashMap();

    @Around(value="@annotation(pro.fessional.wings.tiny.grow.track.TinyTracker)")
    public Object track(ProceedingJoinPoint joinPoint) throws Throwable {
        TinyTracker anno;
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        TinyTracking tracking = this.tryTrack(method, anno = method.getAnnotation(TinyTracker.class));
        if (tracking == null) {
            return joinPoint.proceed();
        }
        tracking.setIns(joinPoint.getArgs());
        tracking.addOmit(this.omitRule(method, anno));
        try {
            Object out = joinPoint.proceed();
            tracking.setOut(out);
            Object object = out;
            return object;
        }
        catch (Throwable e) {
            tracking.setErr(e);
            throw e;
        }
        finally {
            try {
                this.mixAsync(tracking, method, anno, (JoinPoint)joinPoint);
            }
            catch (Throwable e) {
                log.error("tiny-track fails to mixAsync, method=" + MethodConvertor.method2Str((Method)method), e);
            }
        }
    }

    protected void mixAsync(@NotNull TinyTracking tracking, @NotNull Method method, @NotNull TinyTracker anno, @NotNull JoinPoint joinPoint) {
        tracking.setElapse(ThreadNow.millis() - tracking.getBegin());
        this.tinyTrackService.async(() -> {
            Method mix = this.findMixer(method, anno);
            if (!Null.asNull((Method)mix)) {
                try {
                    Object[] pm = joinPoint.getArgs();
                    Object[] pn = new Object[pm.length + 1];
                    pn[0] = tracking;
                    System.arraycopy(pm, 0, pn, 1, pm.length);
                    mix.invoke(joinPoint.getTarget(), pn);
                }
                catch (Exception e) {
                    log.error("tiny-track fails to mix=" + MethodConvertor.method2Str((Method)mix), (Throwable)e);
                }
            }
            this.tinyTrackService.track(tracking, false);
        });
    }

    @Nullable
    protected TinyTracking tryTrack(@NotNull Method method, @NotNull TinyTracker anno) {
        try {
            String key = anno.key();
            if (StringUtils.isEmpty((CharSequence)key)) {
                return this.tinyTrackService.begin(method);
            }
            String ref = anno.ref();
            if (StringUtils.isEmpty((CharSequence)ref)) {
                return this.tinyTrackService.begin(key);
            }
            return this.tinyTrackService.begin(key, ref);
        }
        catch (Exception e) {
            log.error("tiny-track fails to beginTracking, method=" + MethodConvertor.method2Str((Method)method), (Throwable)e);
            return null;
        }
    }

    protected Set<Object> omitRule(@NotNull Method method, @NotNull TinyTracker anno) {
        return this.omitRules.computeIfAbsent(method, k -> {
            HashSet<Pattern> set = new HashSet<Pattern>();
            Collections.addAll(set, anno.omitClass());
            Collections.addAll(set, anno.omitEqual());
            for (String ptn : anno.omitRegex()) {
                set.add(Pattern.compile(ptn));
            }
            return set;
        });
    }

    @Nullable
    protected Method findMixer(@NotNull Method method, @NotNull TinyTracker anno) {
        return this.mixMethod.computeIfAbsent(method, k -> {
            try {
                String nm = anno.mix();
                if (nm == null || nm.isBlank()) {
                    nm = method.getName();
                }
                Class<?>[] pm = method.getParameterTypes();
                Class[] pn = new Class[pm.length + 1];
                pn[0] = TinyTracking.class;
                System.arraycopy(pm, 0, pn, 1, pm.length);
                Method md = method.getDeclaringClass().getDeclaredMethod(nm, pn);
                md.setAccessible(true);
                return md;
            }
            catch (Exception e) {
                return Null.Mtd;
            }
        });
    }

    @Autowired
    @Generated
    public void setTinyTrackService(TinyTrackService tinyTrackService) {
        this.tinyTrackService = tinyTrackService;
    }
}

