/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.grow.track.impl;

import com.alibaba.fastjson2.filter.Filter;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pro.fessional.mirana.pain.ThrowableUtil;
import pro.fessional.mirana.time.DateLocaling;
import pro.fessional.wings.faceless.service.lightid.LightIdAware;
import pro.fessional.wings.faceless.service.lightid.LightIdService;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.fastjson.FastJsonHelper;
import pro.fessional.wings.slardar.fastjson.filter.ExcludePropertyPreFilter;
import pro.fessional.wings.tiny.grow.database.autogen.tables.daos.WinGrowTrackDao;
import pro.fessional.wings.tiny.grow.database.autogen.tables.pojos.WinGrowTrack;
import pro.fessional.wings.tiny.grow.track.TinyTrackService;
import pro.fessional.wings.tiny.grow.track.TinyTracking;

@Service
@ConditionalWingsEnabled
public class TinyTrackCollectorDaoImpl
implements TinyTrackService.Collector {
    protected WinGrowTrackDao winGrowTrackDao;
    protected LightIdService lightIdService;

    @Override
    @Transactional
    public void collect(@NotNull TinyTracking tracking) {
        WinGrowTrack pojo = new WinGrowTrack();
        pojo.setId(this.lightIdService.getId((LightIdAware)this.winGrowTrackDao.getTable()));
        this.buildProp(pojo, tracking);
        this.buildExec(pojo, tracking);
        this.winGrowTrackDao.insert(pojo);
    }

    protected void buildProp(@NotNull WinGrowTrack pojo, @NotNull TinyTracking tracking) {
        pojo.setCreateDt(DateLocaling.sysLdt((long)tracking.getBegin()));
        pojo.setTrackKey(tracking.getKey());
        pojo.setTrackRef(tracking.getRef());
        pojo.setTrackApp(tracking.getApp());
        pojo.setElapseMs(tracking.getElapse());
        pojo.setUserKey(tracking.getUserKey());
        pojo.setUserRef(tracking.getUserRef());
        pojo.setDataKey(tracking.getDataKey());
        pojo.setDataRef(tracking.getDataRef());
        pojo.setDataOpt(tracking.getDataOpt());
        pojo.setCodeKey(tracking.getCodeKey());
        pojo.setCodeRef(tracking.getCodeRef());
        pojo.setCodeOpt(tracking.getCodeOpt());
        pojo.setWordRef(tracking.getWordRef());
    }

    protected void buildExec(@NotNull WinGrowTrack pojo, @NotNull TinyTracking tracking) {
        ExcludePropertyPreFilter filter = new ExcludePropertyPreFilter(tracking.getOmitRule());
        pojo.setTrackEnv(FastJsonHelper.string(tracking.getEnv(), (Filter[])new Filter[]{filter}));
        pojo.setTrackIns(FastJsonHelper.string((Object)tracking.getIns(), (Filter[])new Filter[]{filter}));
        pojo.setTrackOut(FastJsonHelper.string((Object)tracking.getOut(), (Filter[])new Filter[]{filter}));
        pojo.setTrackErr(ThrowableUtil.toString((Throwable)tracking.getErr()));
    }

    @Autowired
    @Generated
    public void setWinGrowTrackDao(WinGrowTrackDao winGrowTrackDao) {
        this.winGrowTrackDao = winGrowTrackDao;
    }

    @Autowired
    @Generated
    public void setLightIdService(LightIdService lightIdService) {
        this.lightIdService = lightIdService;
    }
}

