/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.grow.track.impl;

import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Service;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.slardar.context.TerminalAttribute;
import pro.fessional.wings.slardar.context.TerminalContext;
import pro.fessional.wings.tiny.grow.track.TinyTrackService;
import pro.fessional.wings.tiny.grow.track.TinyTracking;

@Service
@ConditionalWingsEnabled
@ConditionalOnClass(value={TerminalContext.class})
public class TinyTrackPreparerTermImpl
implements TinyTrackService.Preparer {
    @Override
    public void prepare(@NotNull TinyTracking tracking) {
        String agt;
        String adr;
        TerminalContext.Context ctx = TerminalContext.get((boolean)false);
        if (ctx.isNull()) {
            return;
        }
        tracking.addEnv("locale", ctx.getLocale().toLanguageTag());
        tracking.addEnv("zoneid", ctx.getZoneId().getId());
        long id = ctx.getUserId();
        tracking.addEnv("userId", id);
        if (id > 0L) {
            tracking.addEnv("authType", ctx.getAuthType().name());
            tracking.addEnv("username", ctx.getUsername());
        }
        if ((adr = (String)ctx.getTerminal(TerminalAttribute.TerminalAddr)) != null) {
            tracking.addEnv("addr", adr);
        }
        if ((agt = (String)ctx.getTerminal(TerminalAttribute.TerminalAgent)) != null) {
            tracking.addEnv("agent", agt);
        }
    }
}

