/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.grow.track.impl;

import com.alibaba.ttl.threadpool.TtlExecutors;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.tiny.grow.track.TinyTrackService;
import pro.fessional.wings.tiny.grow.track.TinyTracking;

@Service
@ConditionalWingsEnabled
public class TinyTrackServiceImpl
implements TinyTrackService,
InitializingBean,
DisposableBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TinyTrackServiceImpl.class);
    private Executor executor;
    private boolean innerExecutor = false;
    protected List<TinyTrackService.Collector> trackCollector;
    protected List<TinyTrackService.Preparer> trackPreparer;

    @Override
    public FutureTask<Void> async(Runnable run) {
        FutureTask<Object> future = new FutureTask<Object>(run, null);
        this.executor.execute(future);
        return future;
    }

    @Override
    @NotNull
    public TinyTracking begin(@NotNull String key, @NotNull String ref) {
        TinyTracking tracking = new TinyTracking(ThreadNow.millis(), key, ref);
        for (TinyTrackService.Preparer pr : this.trackPreparer) {
            try {
                pr.prepare(tracking);
            }
            catch (Exception e) {
                log.error("tiny-track skip failed preparer=" + String.valueOf(pr.getClass()), (Throwable)e);
            }
        }
        return tracking;
    }

    @Override
    public void track(@NotNull TinyTracking tracking, boolean async) {
        if (async) {
            this.executor.execute(() -> this.track(tracking));
        } else {
            this.track(tracking);
        }
    }

    @Override
    public void track(@NotNull TinyTracking tracking) {
        for (TinyTrackService.Collector cl : this.trackCollector) {
            try {
                cl.collect(tracking);
            }
            catch (Exception e) {
                log.error("tiny-track skip failed collector=" + String.valueOf(cl.getClass()), (Throwable)e);
            }
        }
    }

    public void afterPropertiesSet() {
        if (this.executor == null) {
            log.warn("should reuse autowired thread pool");
            this.executor = TtlExecutors.getTtlExecutorService((ExecutorService)Executors.newWorkStealingPool(2));
            this.innerExecutor = true;
        }
    }

    public void destroy() {
        Executor executor;
        if (this.innerExecutor && (executor = this.executor) instanceof ExecutorService) {
            ExecutorService es = (ExecutorService)executor;
            es.shutdown();
        }
    }

    @Autowired(required=false)
    @Qualifier(value="taskExecutor")
    @Generated
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Autowired
    @Generated
    public void setTrackCollector(List<TinyTrackService.Collector> trackCollector) {
        this.trackCollector = trackCollector;
    }

    @Autowired
    @Generated
    public void setTrackPreparer(List<TinyTrackService.Preparer> trackPreparer) {
        this.trackPreparer = trackPreparer;
    }
}

