/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.tiny.mail.service;

import java.time.LocalDateTime;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.cast.BoxedCastUtil;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.tiny.mail.database.autogen.tables.pojos.WinMailSender;
import pro.fessional.wings.tiny.mail.service.TinyMail;
import pro.fessional.wings.tiny.mail.service.TinyMailPlain;

public interface TinyMailService {
    public boolean send(@NotNull TinyMail var1, boolean var2);

    public boolean post(@NotNull TinyMail var1, boolean var2);

    public long emit(@NotNull TinyMail var1, boolean var2);

    default public boolean send(@NotNull TinyMailPlain message) {
        long id = this.save(message);
        return this.send(id, BoxedCastUtil.orFalse((Boolean)message.getRetry()), BoxedCastUtil.orFalse((Boolean)message.getCheck()));
    }

    default public boolean post(@NotNull TinyMailPlain message) {
        long id = this.save(message);
        return this.post(id, BoxedCastUtil.orFalse((Boolean)message.getRetry()), BoxedCastUtil.orFalse((Boolean)message.getCheck()));
    }

    default public long emit(@NotNull TinyMailPlain message) {
        long id = this.save(message);
        return this.emit(id, BoxedCastUtil.orFalse((Boolean)message.getRetry()), BoxedCastUtil.orFalse((Boolean)message.getCheck()));
    }

    public boolean send(long var1, boolean var3, boolean var4);

    public boolean post(long var1, boolean var3, boolean var4);

    public long emit(long var1, boolean var3, boolean var4);

    public long save(@NotNull TinyMailPlain var1);

    public int scan();

    default public long auto(@NotNull TinyMail message, boolean retry) {
        LocalDateTime md = message.getDate();
        if (md == null || md.isBefore(ThreadNow.localDateTime())) {
            boolean ok = this.send(message, retry);
            return ok ? 0L : -1L;
        }
        return this.emit(message, retry);
    }

    default public long auto(@NotNull TinyMailPlain message) {
        long id = this.save(message);
        LocalDateTime md = message.getDate();
        if (md == null || md.isBefore(ThreadNow.localDateTime())) {
            boolean ok = this.send(id, BoxedCastUtil.orFalse((Boolean)message.getRetry()), BoxedCastUtil.orFalse((Boolean)message.getCheck()));
            return ok ? 0L : -1L;
        }
        return this.emit(id, BoxedCastUtil.orFalse((Boolean)message.getRetry()), BoxedCastUtil.orFalse((Boolean)message.getCheck()));
    }

    public static interface StatusHook {
        public boolean stop(@NotNull WinMailSender var1, long var2, Exception var4);
    }
}

